/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatisticsAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CallGraphStatisticsAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.tree.TmfTreeCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class CallGraphStatisticsDataProviderFactory
implements IDataProviderFactory {
    private static final String ID = "org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.callgraphanalysis.statistics";
    private static final IDataProviderDescriptor DESCRIPTOR = new DataProviderDescriptor.Builder().setId("org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.callgraphanalysis.statistics").setName(Objects.requireNonNull(Messages.CallGraphStatistics_Title)).setDescription(Objects.requireNonNull(Messages.CallGraphStatistics_Description)).setProviderType(IDataProviderDescriptor.ProviderType.DATA_TREE).build();

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        if (trace instanceof TmfExperiment) {
            return TmfTreeCompositeDataProvider.create((Collection)TmfTraceManager.getTraceSet((ITmfTrace)trace), (String)ID);
        }
        Iterator csModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CallStackAnalysis.class).iterator();
        if (!csModules.hasNext()) {
            return null;
        }
        CallStackAnalysis csModule = (CallStackAnalysis)csModules.next();
        csModule.schedule();
        ICallGraphProvider cgModule = csModule.getCallGraph();
        if (!(cgModule instanceof CallGraphAnalysis)) {
            return null;
        }
        CallGraphStatisticsAnalysis statisticsAnalysis = new CallGraphStatisticsAnalysis();
        try {
            statisticsAnalysis.setTrace(trace);
        }
        catch (TmfAnalysisException e) {
            statisticsAnalysis.dispose();
            return null;
        }
        statisticsAnalysis.schedule();
        SegmentStoreStatisticsDataProvider dp = new SegmentStoreStatisticsDataProvider(trace, (IStatisticsAnalysis)statisticsAnalysis, ID);
        SymbolFormatter fe = new SymbolFormatter(trace);
        dp.setLabelMapper((UnaryOperator)fe);
        return dp;
    }

    public Collection<IDataProviderDescriptor> getDescriptors(ITmfTrace trace) {
        Iterator csModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CallStackAnalysis.class).iterator();
        if (!csModules.hasNext()) {
            return Collections.emptyList();
        }
        CallStackAnalysis csModule = (CallStackAnalysis)csModules.next();
        ICallGraphProvider cgModule = csModule.getCallGraph();
        if (!(cgModule instanceof CallGraphAnalysis)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(DESCRIPTOR);
    }

    private static final class SymbolFormatter
    implements UnaryOperator<String> {
        private final Collection<ISymbolProvider> fSymbolProviders;

        public SymbolFormatter(@Nullable ITmfTrace trace) {
            this.fSymbolProviders = trace != null ? SymbolProviderManager.getInstance().getSymbolProviders(trace) : Collections.emptySet();
        }

        @Override
        public String apply(String original) {
            try {
                Long address = Long.decode(original);
                return SymbolProviderUtils.getSymbolText(this.fSymbolProviders, (long)address);
            }
            catch (NumberFormatException e) {
                return original;
            }
        }
    }
}

