/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.CExtensionInfo;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.core.runtime.CoreException;

public class CConfigExtensionReference
implements ICConfigExtensionReference {
    private CConfigurationSpecSettings fCfgSettings;
    private String fExtPoint;
    private String fId;

    public CConfigExtensionReference(CConfigurationSpecSettings cfg, String extPoint, String id) {
        this.fCfgSettings = cfg;
        this.fExtPoint = extPoint;
        this.fId = id;
    }

    public CConfigExtensionReference(CConfigurationSpecSettings cfg, CConfigExtensionReference base) {
        this.fCfgSettings = cfg;
        this.fExtPoint = base.fExtPoint;
        this.fId = base.fId;
    }

    @Override
    public String getExtensionPoint() {
        return this.fExtPoint;
    }

    @Override
    public String getID() {
        return this.fId;
    }

    private CExtensionInfo getInfo() {
        return this.fCfgSettings.getInfo(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CConfigExtensionReference) {
            CConfigExtensionReference ext = (CConfigExtensionReference)obj;
            if (ext.fExtPoint.equals(this.fExtPoint) && ext.fId.equals(this.fId)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fExtPoint.hashCode() + this.fId.hashCode();
    }

    @Override
    public void setExtensionData(String key, String value) throws CoreException {
        this.getInfo().setAttribute(key, value);
        this.fCfgSettings.setModified();
    }

    @Override
    public String getExtensionData(String key) {
        return this.getInfo().getAttribute(key);
    }

    @Override
    public ICConfigurationDescription getConfiguration() {
        return this.fCfgSettings.getConfigurarion();
    }
}

