/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlEventHandlerCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlLocationCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlMappingGroupCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenStateProvider;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;

public class TmfXmlStateProviderCu {
    private final List<TmfXmlEventHandlerCu> fEventHandlers;
    private final List<TmfXmlMappingGroupCu> fMapGroups;
    private final String fProviderId;
    private final int fVersion;

    TmfXmlStateProviderCu(String providerId, int version, List<TmfXmlMappingGroupCu> mapGroups, List<TmfXmlEventHandlerCu> eventHandlers) {
        this.fEventHandlers = eventHandlers;
        this.fMapGroups = mapGroups;
        this.fProviderId = providerId;
        this.fVersion = version;
    }

    public DataDrivenStateProvider generate(ITmfTrace trace) {
        List<DataDrivenEventHandler> eventHandlers = this.fEventHandlers.stream().map(TmfXmlEventHandlerCu::generate).collect(Collectors.toList());
        List<DataDrivenMappingGroup> mappingGroups = this.fMapGroups.stream().map(TmfXmlMappingGroupCu::generate).collect(Collectors.toList());
        return new DataDrivenStateProvider(trace, this.fProviderId, this.fVersion, eventHandlers, mappingGroups);
    }

    public static @Nullable TmfXmlStateProviderCu compile(Path file, String providerId) {
        int version;
        Element spEl = TmfXmlUtils.getElementInFile(file.toAbsolutePath().toString(), "stateProvider", providerId);
        if (spEl == null) {
            Activator.logError("XmlStateProvider: Cannot find state provider element in file " + file);
            return null;
        }
        AnalysisCompilationData analysisData = new AnalysisCompilationData();
        try {
            version = Integer.parseInt(spEl.getAttribute("version"));
        }
        catch (NumberFormatException e) {
            Activator.logError("XmlStateProvider: The version is not a parseable integer");
            return null;
        }
        List<Element> childElements = TmfXmlUtils.getChildElements(spEl, "definedValue");
        for (Element element : childElements) {
            analysisData.addDefinedValue(element.getAttribute("name"), element.getAttribute("value"));
        }
        childElements = TmfXmlUtils.getChildElements(spEl, "location");
        for (Element element : childElements) {
            TmfXmlLocationCu.compile(analysisData, element);
        }
        ArrayList<TmfXmlMappingGroupCu> mapGroups = new ArrayList<TmfXmlMappingGroupCu>();
        childElements = TmfXmlUtils.getChildElements(spEl, "mappingGroup");
        for (Element map : childElements) {
            TmfXmlMappingGroupCu compile = TmfXmlMappingGroupCu.compile(analysisData, map);
            if (compile == null) {
                return null;
            }
            mapGroups.add(compile);
        }
        childElements = TmfXmlUtils.getChildElements(spEl, "eventHandler");
        ArrayList<TmfXmlEventHandlerCu> handlers = new ArrayList<TmfXmlEventHandlerCu>();
        for (Element element : childElements) {
            TmfXmlEventHandlerCu compile = TmfXmlEventHandlerCu.compile(analysisData, element);
            if (compile == null) {
                return null;
            }
            handlers.add(compile);
        }
        return new TmfXmlStateProviderCu(providerId, version, mapGroups, handlers);
    }
}

