/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfTreeCompositeDataProvider<M extends ITmfTreeDataModel, P extends ITmfTreeDataProvider<M>>
implements ITmfTreeDataProvider<M>,
IOutputAnnotationProvider {
    private final CopyOnWriteArrayList<P> fProviders = new CopyOnWriteArrayList();
    private final String fId;

    public static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(Collection<ITmfTrace> traces, String id) {
        ArrayList<@NonNull ITmfTreeDataProvider> providers = new ArrayList<ITmfTreeDataProvider>();
        for (ITmfTrace child : traces) {
            ITmfTreeDataProvider provider = DataProviderManager.getInstance().getDataProvider(child, id, ITmfTreeDataProvider.class);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITmfTreeDataProvider)providers.get(0);
        }
        return new TmfTreeCompositeDataProvider(providers, id);
    }

    public TmfTreeCompositeDataProvider(List<P> providers, String id) {
        this.fProviders.addAll(providers);
        this.fId = id;
    }

    @Override
    public TmfModelResponse<TmfTreeModel<M>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean isComplete = true;
        ImmutableList.Builder series = ImmutableList.builder();
        List<ITableColumnDescriptor> columnDescriptor = null;
        for (ITmfTreeDataProvider dataProvider : this.fProviders) {
            TmfModelResponse response = dataProvider.fetchTree(fetchParameters, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            TmfTreeModel model = response.getModel();
            if (model != null) {
                series.addAll(model.getEntries());
                if (columnDescriptor == null) {
                    columnDescriptor = model.getColumnDescriptors();
                }
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        TmfTreeModel.Builder treeModelBuilder = new TmfTreeModel.Builder();
        if (columnDescriptor == null) {
            columnDescriptor = Collections.emptyList();
        }
        treeModelBuilder.setColumnDescriptors(columnDescriptor).setEntries(series.build());
        if (isComplete) {
            return new TmfModelResponse<TmfTreeModel<M>>(treeModelBuilder.build(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<TmfTreeModel<M>>(treeModelBuilder.build(), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    @Override
    public String getId() {
        return this.fId;
    }

    protected List<P> getProviders() {
        return this.fProviders;
    }

    protected void addProvider(P dataProvider) {
        this.fProviders.add(dataProvider);
    }

    protected void removeProvider(P dataProvider) {
        this.fProviders.remove(dataProvider);
        dataProvider.dispose();
    }

    @Override
    public void dispose() {
        this.fProviders.forEach((Consumer<P>)((Consumer<ITmfTreeDataProvider>)ITmfTreeDataProvider::dispose));
        this.fProviders.clear();
    }

    @Override
    public TmfModelResponse<AnnotationCategoriesModel> fetchAnnotationCategories(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        HashSet<String> categories = new HashSet<String>();
        for (ITmfTreeDataProvider dataProvider : this.getProviders()) {
            TmfModelResponse<AnnotationCategoriesModel> response;
            AnnotationCategoriesModel model;
            if (!(dataProvider instanceof IOutputAnnotationProvider) || (model = (response = ((IOutputAnnotationProvider)((Object)dataProvider)).fetchAnnotationCategories(fetchParameters, monitor)).getModel()) == null) continue;
            categories.addAll(model.getAnnotationCategories());
        }
        if (categories.isEmpty()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<AnnotationCategoriesModel>(new AnnotationCategoriesModel((List<String>)ImmutableList.copyOf(categories)), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Override
    public TmfModelResponse<AnnotationModel> fetchAnnotations(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean isComplete = true;
        ImmutableMap.Builder annotationsBuilder = ImmutableMap.builder();
        for (ITmfTreeDataProvider dataProvider : this.getProviders()) {
            if (!(dataProvider instanceof IOutputAnnotationProvider)) continue;
            TmfModelResponse<AnnotationModel> response = ((IOutputAnnotationProvider)((Object)dataProvider)).fetchAnnotations(fetchParameters, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            AnnotationModel model = response.getModel();
            if (model != null) {
                annotationsBuilder.putAll(model.getAnnotations());
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        if (isComplete) {
            return new TmfModelResponse<AnnotationModel>(new AnnotationModel((Map<String, Collection<Annotation>>)annotationsBuilder.build()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<AnnotationModel>(new AnnotationModel((Map<String, Collection<Annotation>>)annotationsBuilder.build()), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }
}

