/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap;

import java.util.List;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.TmfMipmapFeature;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class AvgMipmapFeature
extends TmfMipmapFeature {
    public AvgMipmapFeature(int baseQuark, int mipmapQuark, int mipmapResolution, ITmfStateSystemBuilder ss) {
        super(baseQuark, mipmapQuark, mipmapResolution, ss);
    }

    @Override
    protected ITmfStateValue computeMipmapValue(List<ITmfStateInterval> lowerIntervals, long startTime, long endTime) {
        long range = endTime - startTime;
        if (range <= 0L) {
            return TmfStateValue.newValueDouble((double)0.0);
        }
        double sum = 0.0;
        for (ITmfStateInterval interval : lowerIntervals) {
            ITmfStateValue value = interval.getStateValue();
            long duration = interval.getEndTime() - interval.getStartTime();
            if (value.getType() == ITmfStateValue.Type.DOUBLE) {
                sum += value.unboxDouble() * (double)duration;
                continue;
            }
            sum += (double)value.unboxLong() * (double)duration;
        }
        double average = sum / (double)range;
        TmfStateValue avgValue = TmfStateValue.newValueDouble((double)average);
        return avgValue;
    }
}

