/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICProjectDescriptionStorageType;
import org.eclipse.cdt.internal.core.settings.model.SetCProjectDescriptionOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Version;

public abstract class AbstractCProjectDescriptionStorage {
    public final ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy type;
    public final Version version;
    protected volatile IProject project;
    private final ThreadLocal<Boolean> setProjectDescriptionOperationRunning = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final ThreadLocal<ICProjectDescription> currentThreadProjectDescription = new ThreadLocal();

    public AbstractCProjectDescriptionStorage(ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy type, IProject project, Version version) {
        this.type = type;
        this.project = project;
        this.version = version;
    }

    public final IProject getProject() {
        return this.project;
    }

    public void handleProjectMove(IProject newProject, IProject oldProject) {
        this.project = newProject;
    }

    public abstract ICSettingsStorage getStorageForElement(ICStorageElement var1) throws CoreException;

    public ICStorageElement copyElement(ICStorageElement el, boolean writable) throws CoreException {
        return null;
    }

    public ICProjectDescription getProjectDescription(int flags, IProgressMonitor monitor) throws CoreException {
        if (!this.project.isAccessible()) {
            throw ExceptionFactory.createCoreException(MessageFormat.format((String)CCorePlugin.getResourceString("ProjectDescription.ProjectNotAccessible"), (Object[])new Object[]{this.getProject().getName()}));
        }
        return this.currentThreadProjectDescription.get();
    }

    public void setProjectDescription(final ICProjectDescription description, final int flags, IProgressMonitor monitor) throws CoreException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ICProject cproject = CModelManager.getDefault().create(this.project);
            SetCProjectDescriptionOperation op = new SetCProjectDescriptionOperation(this, cproject, (CProjectDescription)description, flags);
            if (this.setProjectDescriptionOperationRunning.get().booleanValue()) {
                CCorePlugin.log("API Error: setProjectDescription() shouldn't be called recursively.", new Exception());
                Job j = new Job("setProjectDescription rescheduled"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            AbstractCProjectDescriptionStorage.this.setProjectDescription(description, flags, monitor);
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                j.setSystem(true);
                j.schedule();
                return;
            }
            try {
                try {
                    this.setProjectDescriptionOperationRunning.set(true);
                    op.runOperation(monitor);
                }
                catch (IllegalArgumentException e) {
                    throw ExceptionFactory.createCoreException(e);
                }
            }
            finally {
                this.setProjectDescriptionOperationRunning.set(false);
            }
        }
        finally {
            monitor.done();
        }
    }

    public abstract boolean setCurrentDescription(ICProjectDescription var1, boolean var2);

    public abstract IWorkspaceRunnable createDesSerializationRunnable() throws CoreException;

    public void projectMove(IProject newProject) {
        this.project = newProject;
    }

    public void projectCloseRemove() {
    }

    public static final void fireLoadedEvent(ICProjectDescription desc) {
        CProjectDescriptionManager.getInstance().notifyListeners(new CProjectDescriptionEvent(1, null, desc, null, null));
    }

    public static final void fireCopyCreatedEvent(ICProjectDescription newDes, ICProjectDescription oldDes) {
        CProjectDescriptionManager.getInstance().notifyListeners(new CProjectDescriptionEvent(8, null, newDes, oldDes, null));
    }

    public static final void fireAboutToApplyEvent(ICProjectDescription newDes, ICProjectDescription oldDes) {
        CProjectDescriptionManager.getInstance().notifyListeners(new CProjectDescriptionEvent(2, null, newDes, oldDes, null));
    }

    public static final CProjectDescriptionEvent createAppliedEvent(ICProjectDescription newDes, ICProjectDescription oldDes, ICProjectDescription appliedDes, ICDescriptionDelta delta) {
        return new CProjectDescriptionEvent(4, delta, newDes, oldDes, appliedDes);
    }

    public static final void fireAppliedEvent(ICProjectDescription newDes, ICProjectDescription oldDes, ICProjectDescription appliedDes, ICDescriptionDelta delta) {
        CProjectDescriptionManager.getInstance().notifyListeners(AbstractCProjectDescriptionStorage.createAppliedEvent(newDes, oldDes, appliedDes, delta));
    }

    public static final void fireDataAppliedEvent(ICProjectDescription newDes, ICProjectDescription oldDes, ICProjectDescription appliedDes, ICDescriptionDelta delta) {
        CProjectDescriptionManager.getInstance().notifyListeners(new CProjectDescriptionEvent(16, delta, newDes, oldDes, appliedDes));
    }

    protected static final boolean checkFlags(int flags, int check) {
        return (flags & check) == check;
    }

    public ICProjectDescription setThreadLocalProjectDesc(ICProjectDescription currentDesc) {
        ICProjectDescription current = this.currentThreadProjectDescription.get();
        this.currentThreadProjectDescription.set(currentDesc);
        return current;
    }
}

