/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.RefPair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MultiplePrototypeRefPair<S, T>
extends RefPair<S, T> {
    private final ConcurrentMap<ComponentContextImpl<S>, T> instances = new ConcurrentHashMap<ComponentContextImpl<S>, T>();

    public MultiplePrototypeRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public T getServiceObject(ComponentContextImpl<S> key) {
        return (T)this.instances.get(key);
    }

    @Override
    public boolean setServiceObject(ComponentContextImpl<S> key, T serviceObject) {
        return this.instances.putIfAbsent(key, serviceObject) == null;
    }

    @Override
    public T unsetServiceObject(ComponentContextImpl<S> key) {
        if (key == null) {
            for (Map.Entry e : this.instances.entrySet()) {
                this.doUngetService((ComponentContextImpl)e.getKey(), e.getValue());
            }
            this.instances.clear();
            return null;
        }
        Object service = this.instances.remove(key);
        if (service != null) {
            this.doUngetService(key, service);
        }
        return (T)service;
    }

    public String toString() {
        return "[MultiplePrototypeRefPair: ref: [" + this.getRef() + "] has service: [" + !this.instances.isEmpty() + "]]";
    }

    @Override
    public boolean getServiceObject(ComponentContextImpl<S> key, BundleContext context) {
        Object service = key.getComponentServiceObjectsHelper().getPrototypeRefInstance(this.getRef());
        if (service == null) {
            this.setFailed();
            key.getLogger().log(2, "Could not get service from serviceobjects for ref {0}", null, this.getRef());
            return false;
        }
        if (!this.setServiceObject(key, service)) {
            this.doUngetService(key, service);
        }
        return true;
    }

    private void doUngetService(ComponentContextImpl<S> key, T service) {
        try {
            key.getComponentServiceObjectsHelper().getServiceObjects(this.getRef()).ungetService(service);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

