/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.commands;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.events.columns.TmfEventTableColumn;
import org.eclipse.ui.PlatformUI;

public class CopyToClipboardOperation
implements IRunnableWithProgress {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final ITmfTrace fTrace;
    private final ITmfFilter fFilter;
    private final List<TmfEventTableColumn> fColumns;
    private final long fStartRank;
    private final long fEndRank;

    public CopyToClipboardOperation(ITmfTrace trace, ITmfFilter filter, List<TmfEventTableColumn> columns, long start, long end) {
        this.fTrace = trace;
        this.fFilter = filter;
        this.fColumns = columns;
        this.fStartRank = start;
        this.fEndRank = end;
    }

    public void run(IProgressMonitor monitor) {
        StringBuilder sb = new StringBuilder();
        monitor.beginTask(Messages.CopyToClipboardOperation_TaskName, (int)(this.fEndRank - this.fStartRank + 1L));
        boolean needTab = false;
        for (TmfEventTableColumn column : this.fColumns) {
            if (needTab) {
                sb.append('\t');
            }
            sb.append(column.getHeaderName());
            needTab = true;
        }
        sb.append(LINE_SEPARATOR);
        this.copy(sb, monitor);
        Display.getDefault().syncExec(() -> {
            if (sb.length() == 0) {
                return;
            }
            Clipboard clipboard = new Clipboard(Display.getDefault());
            try {
                try {
                    clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                }
                catch (OutOfMemoryError e) {
                    sb.setLength(0);
                    sb.trimToSize();
                    CopyToClipboardOperation.showErrorDialog();
                    clipboard.dispose();
                }
            }
            finally {
                clipboard.dispose();
            }
        });
        monitor.done();
    }

    private IStatus copy(final StringBuilder sb, final IProgressMonitor monitor) {
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, TmfTimeRange.ETERNITY, this.fStartRank, (int)(this.fEndRank - this.fStartRank + 1L), ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (monitor.isCanceled()) {
                    this.cancel();
                    return;
                }
                monitor.worked(1);
                if (CopyToClipboardOperation.this.fFilter == null || CopyToClipboardOperation.this.fFilter.matches(event)) {
                    try {
                        boolean needTab = false;
                        for (TmfEventTableColumn column : CopyToClipboardOperation.this.fColumns) {
                            if (needTab) {
                                sb.append('\t');
                            }
                            sb.append(column.getItemString(event));
                            needTab = true;
                        }
                        sb.append(LINE_SEPARATOR);
                    }
                    catch (OutOfMemoryError e) {
                        sb.setLength(0);
                        sb.trimToSize();
                        CopyToClipboardOperation.showErrorDialog();
                        this.cancel();
                    }
                }
            }
        };
        this.fTrace.sendRequest((ITmfEventRequest)request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError("Wait for completion interrupted for copy to clipboard ", e);
            Thread.currentThread().interrupt();
        }
        return Status.OK_STATUS;
    }

    private static void showErrorDialog() {
        Display.getDefault().syncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageBox confirmOperation = new MessageBox(shell, 33);
            confirmOperation.setText(Messages.CopyToClipboardOperation_OutOfMemoryErrorTitle);
            confirmOperation.setMessage(Messages.CopyToClipboardOperation_OutOfMemoryErrorMessage);
            confirmOperation.open();
        });
    }
}

