/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation.core.errorinfo;

import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.validation.XMLValidationUIMessages;

public class TaskListTableViewer
extends TableViewer {
    protected static final int COLUMN_ICON = 0;
    protected static final int COLUMN_DESCRIPTION = 1;
    protected static final int COLUMN_RESOURCE = 3;
    protected static final int COLUMN_LOCATION = 2;
    protected static final String LABEL_ICON = "";
    protected static final String LABEL_DESCRIPTION = XMLValidationUIMessages.TaskListTableViewer_0;
    protected static final String LABEL_RESOURCE = XMLValidationUIMessages.TaskListTableViewer_1;
    protected static final String LABEL_LOCATION = XMLValidationUIMessages.TaskListTableViewer_2;
    protected int visibleRows = -1;

    protected int getColumnWidth(int column) {
        int result = 0;
        switch (column) {
            case 0: {
                result = 1;
                break;
            }
            case 1: {
                result = 20;
                break;
            }
            case 3: {
                result = 3;
                break;
            }
            case 2: {
                result = 3;
            }
        }
        return result;
    }

    public TaskListTableViewer(Composite parent, int visibleRows) {
        this(parent, 67586, visibleRows);
    }

    public TaskListTableViewer(Composite parent, int style, int visibleRows) {
        super(new Table(parent, style));
        this.getTable().setLinesVisible(true);
        Provider provider = new Provider();
        this.setContentProvider((IContentProvider)provider);
        this.setLabelProvider((IBaseLabelProvider)provider);
        String[] columnPropertiesArray = new String[]{LABEL_ICON, LABEL_DESCRIPTION, LABEL_LOCATION};
        this.setColumnProperties(columnPropertiesArray);
        Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < columnPropertiesArray.length) {
            TableColumn column = new TableColumn(table, i);
            column.setText(columnPropertiesArray[i]);
            column.setAlignment(16384);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.getColumnWidth(i), true));
            ++i;
        }
        table.setLayout((Layout)layout);
        this.visibleRows = visibleRows;
    }

    protected class Provider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        Viewer viewer;
        Image errorImage = XMLUIPlugin.getInstance().getImage("IMG_OBJS_ERROR_TSK");
        Image warnImage = XMLUIPlugin.getInstance().getImage("IMG_OBJS_WARN_TSK");

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
        }

        public Object[] getElements(Object inputElement) {
            List list = (List)this.viewer.getInput();
            return list != null ? list.toArray() : null;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            ValidationMessage validationMessage = (ValidationMessage)object;
            Image result = null;
            if (columnIndex == 0) {
                int severity = validationMessage.getSeverity();
                result = severity == 1 || severity == 2 ? this.errorImage : this.warnImage;
            }
            return result;
        }

        public String getColumnText(Object object, int column) {
            ValidationMessage errorMessage = (ValidationMessage)object;
            String result = TaskListTableViewer.LABEL_ICON;
            switch (column) {
                case 1: {
                    result = errorMessage.getMessage();
                    break;
                }
                case 2: {
                    result = String.valueOf(XMLValidationUIMessages.TaskListTableViewer_3) + errorMessage.getLineNumber();
                }
            }
            return result;
        }
    }
}

