/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.project.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;

public class TraceTypeHelper {
    private static final String SEP = " : ";
    private final String fName;
    private final String fCategoryName;
    private final @NonNull String fTraceTypeId;
    private final TmfTraceType.TraceElementType fElementType;
    private final @NonNull ITmfTrace fTrace;
    private final boolean fIsDirectory;
    private boolean fEnable;

    public TraceTypeHelper(String traceTypeId, String categoryName, String name, @NonNull ITmfTrace trace, boolean isDir, TmfTraceType.TraceElementType elementType) {
        this.fName = name;
        this.fCategoryName = categoryName;
        this.fTraceTypeId = traceTypeId;
        this.fTrace = trace;
        this.fIsDirectory = isDir;
        this.fElementType = elementType;
        this.fEnable = true;
    }

    public String getName() {
        return this.fName;
    }

    public String getCategoryName() {
        return this.fCategoryName;
    }

    public String getLabel() {
        if (this.fCategoryName.isEmpty()) {
            return this.fName;
        }
        return String.valueOf(this.fCategoryName) + SEP + this.fName;
    }

    public @NonNull String getTraceTypeId() {
        return this.fTraceTypeId;
    }

    public IStatus validate(String path) {
        return this.fTrace.validate(null, path);
    }

    public int validateWithConfidence(String path) {
        int result = -1;
        IStatus status = this.fTrace.validate(null, path);
        if (status.getSeverity() != 4) {
            result = 0;
            if (status instanceof TraceValidationStatus) {
                result = ((TraceValidationStatus)status).getConfidence();
            }
        }
        return result;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public boolean isExperimentType() {
        return this.fElementType == TmfTraceType.TraceElementType.EXPERIMENT;
    }

    public Class<@NonNull ? extends ITmfTrace> getTraceClass() {
        return this.fTrace.getClass();
    }

    public boolean isDirectoryTraceType() {
        return this.fIsDirectory;
    }

    public boolean isEnabled() {
        return this.fEnable;
    }

    public void setEnabled(boolean enable) {
        this.fEnable = enable;
    }

    public String toString() {
        return this.fName;
    }
}

