/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.swtchart.model.DoubleArraySeriesModel;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.viewers.xychart.BaseXYPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataTypeUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfCommonXLineChartTooltipProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfXYChartSettings;

public abstract class TmfCommonXAxisChartViewer
extends TmfXYChartViewer {
    private static final String DIRTY_UNDERFLOW_ERROR = "Dirty underflow error";
    private static final @NonNull RGBAColor DEFAULT_COLOR = new RGBAColor(0, 0, 0);
    private static final int DEFAULT_SYMBOL_SIZE = 4;
    private static final Map<String, ILineSeries.PlotSymbolType> SYMBOL_MAP;
    private static final ColorRegistry COLOR_REGISTRY;
    private static final double DEFAULT_MAXY = Double.MIN_VALUE;
    private static final double DEFAULT_MINY = Double.MAX_VALUE;
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final @NonNull Logger LOGGER;
    private static final int DEFAULT_SERIES_WIDTH = 1;
    private static final String DIMMED_SERIES_SUFFIX = ".dimmed";
    private final double fResolution;
    private final AtomicInteger fDirty = new AtomicInteger();
    private final Map<ITmfTrace, BaseXYPresentationProvider> fXYPresentationProvider;
    private UpdateThread fUpdateThread;
    private int fOverrideNbPoints = 0;

    static {
        COLOR_REGISTRY = new ColorRegistry();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"none", (Object)ILineSeries.PlotSymbolType.NONE);
        builder.put((Object)"circle", (Object)ILineSeries.PlotSymbolType.CIRCLE);
        builder.put((Object)"cross", (Object)ILineSeries.PlotSymbolType.CROSS);
        builder.put((Object)"diamond", (Object)ILineSeries.PlotSymbolType.DIAMOND);
        builder.put((Object)"inverted-triangle", (Object)ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
        builder.put((Object)"triangle", (Object)ILineSeries.PlotSymbolType.TRIANGLE);
        builder.put((Object)"plus", (Object)ILineSeries.PlotSymbolType.PLUS);
        builder.put((Object)"square", (Object)ILineSeries.PlotSymbolType.SQUARE);
        SYMBOL_MAP = builder.build();
        LOGGER = TraceCompassLog.getLogger(TmfCommonXAxisChartViewer.class);
    }

    public TmfCommonXAxisChartViewer(Composite parent, TmfXYChartSettings settings) {
        super(parent, settings.getTitle(), settings.getXLabel(), settings.getYLabel());
        this.getSwtChart().getTitle().setVisible(false);
        this.getSwtChart().getLegend().setPosition(1024);
        this.getSwtChart().getAxisSet().getXAxes()[0].getTitle().setVisible(false);
        this.fResolution = settings.getResolution();
        this.setTooltipProvider(new TmfCommonXLineChartTooltipProvider(this));
        this.fXYPresentationProvider = new HashMap<ITmfTrace, BaseXYPresentationProvider>();
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.fXYPresentationProvider.computeIfAbsent(trace, t -> this.createPresentationProvider(trace));
    }

    protected BaseXYPresentationProvider createPresentationProvider(ITmfTrace trace) {
        return new BaseXYPresentationProvider();
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.fDirty.get() != 0;
    }

    public synchronized void setNbPoints(int nbPoints) {
        if (nbPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative");
        }
        this.fOverrideNbPoints = nbPoints;
        this.updateContent();
    }

    protected abstract ITmfXYDataProvider initializeDataProvider(@NonNull ITmfTrace var1);

    public BaseXYPresentationProvider getPresentationProvider() {
        return Objects.requireNonNull(this.fXYPresentationProvider.get(this.getTrace()));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Map<String, Object> createQueryParameters(long start, long end, int nb) {
        @NonNull @NonNull Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(start, end, nb));
        Multimap<@NonNull Integer, @NonNull String> regexesMap = this.getRegexes();
        if (!regexesMap.isEmpty()) {
            parameters.put("regex_map_filters", regexesMap.asMap());
        }
        return parameters;
    }

    public @NonNull OutputElementStyle getSeriesStyle(@NonNull Long seriesId) {
        return this.getPresentationProvider().getSeriesStyle(seriesId, "line", 1);
    }

    protected synchronized void cancelUpdate() {
        if (this.fUpdateThread != null) {
            this.fUpdateThread.cancel();
        }
    }

    @Override
    protected void updateContent() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        this.cancelUpdate();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog parentScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:ContentUpdateRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fDirty.incrementAndGet();
            TmfCommonXAxisChartViewer.getDisplay().asyncExec(() -> {
                if (!trace.equals(this.getTrace())) {
                    return;
                }
                Throwable throwable = null;
                Object var4_5 = null;
                try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:CreatingUpdateThread", new Object[0]).setParentScope(parentScope).build();){
                    this.newUpdateThread(trace, scope);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void clearContent() {
        this.getSwtChart().getAxisSet().getXAxis(0).getTick().setFormat(null);
        super.clearContent();
    }

    private @NonNull String getViewerId() {
        return this.getClass().getName();
    }

    private synchronized void newUpdateThread(@NonNull ITmfTrace trace, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog fScope) {
        if (this.getSwtChart().isDisposed()) {
            return;
        }
        int numRequests = this.fOverrideNbPoints != 0 ? this.fOverrideNbPoints : (int)Math.min(this.getWindowEndTime() - this.getWindowStartTime() + 1L, (long)((double)this.getSwtChart().getPlotArea().getSize().x * this.fResolution));
        UpdateThread oldUpdateThread = this.fUpdateThread;
        if (oldUpdateThread != null) {
            oldUpdateThread.cancel();
        }
        this.fUpdateThread = new UpdateThread(trace, numRequests, fScope);
        this.fUpdateThread.start();
    }

    @Override
    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        this.cancelUpdate();
        super.traceClosed(signal);
        if (signal != null) {
            this.fXYPresentationProvider.remove(signal.getTrace());
        }
    }

    @TmfSignalHandler
    public void regexFilterApplied(TmfFilterAppliedSignal signal) {
        this.updateContent();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        @NonNull @NonNull HashMultimap regexes = HashMultimap.create();
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return regexes;
        }
        TraceCompassFilter globalFilter = TraceCompassFilter.getFilterForTrace((ITmfTrace)trace);
        if (globalFilter == null) {
            return regexes;
        }
        regexes.putAll((Object)1, (Iterable)globalFilter.getRegexes());
        return regexes;
    }

    private class UpdateThread
    extends Thread {
        private final ITmfTrace fTrace;
        private final IProgressMonitor fMonitor;
        private final int fNumRequests;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public UpdateThread(ITmfTrace trace, @NonNull int numRequests, TraceCompassLogUtils.FlowScopeLog log) {
            super("Line chart update");
            this.fTrace = trace;
            this.fNumRequests = numRequests;
            this.fMonitor = new NullProgressMonitor();
            this.fScope = log;
        }

        @Override
        public void run() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateThread", new Object[]{"numRequests=", this.fNumRequests}).setParentScope(this.fScope).build();){
                ITmfXYDataProvider dataProvider = null;
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (TraceCompassLogUtils.FlowScopeLog scopeDp = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:InitializeDataProvider", new Object[0]).setParentScope(this.fScope).build();){
                    dataProvider = TmfCommonXAxisChartViewer.this.initializeDataProvider(this.fTrace);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                if (dataProvider == null) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"Data provider for this viewer is not available", (Object[])new Object[0]);
                    return;
                }
                try {
                    int numRequests = this.fNumRequests;
                    if (numRequests == 0) {
                        return;
                    }
                    Map<String, Object> parameters = TmfCommonXAxisChartViewer.this.createQueryParameters(TmfCommonXAxisChartViewer.this.getWindowStartTime(), TmfCommonXAxisChartViewer.this.getWindowEndTime(), numRequests);
                    this.updateData(dataProvider, parameters, this.fMonitor);
                }
                finally {
                    if (TmfCommonXAxisChartViewer.this.fDirty.decrementAndGet() < 0) {
                        Activator.getDefault().logError(TmfCommonXAxisChartViewer.DIRTY_UNDERFLOW_ERROR, new Throwable());
                    }
                }
                this.updateThreadFinished(this);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }

        public void cancel() {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"CommonXLineChart:UpdateThreadCanceled", (Object[])new Object[0]);
            this.fMonitor.setCanceled(true);
        }

        private void updateData(@NonNull ITmfXYDataProvider dataProvider, @NonNull Map<String, Object> parameters, IProgressMonitor monitor) {
            boolean isComplete = false;
            do {
                ITmfResponse.Status status;
                TmfModelResponse response;
                ITmfXyModel model;
                if ((model = (ITmfXyModel)(response = dataProvider.fetchXY(parameters, monitor)).getModel()) != null) {
                    this.updateDisplay(model, monitor);
                }
                if ((status = response.getStatus()) == ITmfResponse.Status.COMPLETED) {
                    isComplete = true;
                    continue;
                }
                if (status == ITmfResponse.Status.FAILED || status == ITmfResponse.Status.CANCELLED) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)response.getStatusMessage(), (Object[])new Object[0]);
                    isComplete = true;
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)e.getMessage(), (Object[])new Object[0]);
                    Thread.currentThread().interrupt();
                }
            } while (!isComplete);
        }

        private void updateDisplay(ITmfXyModel model, IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TmfCommonXAxisChart:UpdateDisplayRequested", new Object[0]).setCategory(TmfCommonXAxisChartViewer.this.getViewerId()).build();){
                ITmfXyModel seriesValues = model;
                TmfCommonXAxisChartViewer.this.fDirty.incrementAndGet();
                Display.getDefault().asyncExec(() -> this.lambda$0(scope, monitor, seriesValues));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private double[] extractXValuesToDisplay(long[] xValuesRequested) {
            double[] xValuesToDisplay = new double[xValuesRequested.length];
            long offset = TmfCommonXAxisChartViewer.this.getTimeOffset();
            int i = 0;
            while (i < xValuesRequested.length) {
                xValuesToDisplay[i] = xValuesRequested[i] - offset;
                ++i;
            }
            return xValuesToDisplay;
        }

        private @NonNull ISeries<Integer> createSWTSeriesFromModel(ISeriesModel yModel) {
            ISeriesSet seriesSet = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet();
            String seriesName = yModel.getName();
            OutputElementStyle appearance = TmfCommonXAxisChartViewer.this.getSeriesStyle(yModel.getId());
            BaseXYPresentationProvider presProvider = TmfCommonXAxisChartViewer.this.getPresentationProvider();
            String type = (String)presProvider.getStyleOrDefault(appearance, "series-type", "line");
            RGBAColor rgb = presProvider.getColorStyleOrDefault(appearance, "color", DEFAULT_COLOR);
            COLOR_REGISTRY.put(rgb.toString(), RGBAUtil.fromRGBAColor((RGBAColor)rgb).rgb);
            Color color = COLOR_REGISTRY.get(rgb.toString());
            String symbolType = (String)presProvider.getStyle(appearance, "symbol-type");
            if (type.equals("bar")) {
                IBarSeries barSeries = (IBarSeries)seriesSet.createSeries(ISeries.SeriesType.BAR, seriesName);
                barSeries.setBarColor(color);
                barSeries.setBarPadding(0);
                barSeries.setVisible(true);
                return barSeries;
            }
            ILineSeries lineSeries = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
            lineSeries.enableArea("area".equals(type));
            lineSeries.setLineStyle(LineStyle.valueOf((String)((String)presProvider.getStyleOrDefault(appearance, "series-style", "SOLID"))));
            lineSeries.setSymbolType(SYMBOL_MAP.getOrDefault(symbolType, ILineSeries.PlotSymbolType.NONE));
            lineSeries.setSymbolSize(Math.round(presProvider.getFloatStyleOrDefault(appearance, "height", Float.valueOf(1.0f)).floatValue() * 4.0f));
            lineSeries.setLineColor(color);
            lineSeries.setSymbolColor(color);
            lineSeries.setVisible(true);
            lineSeries.setLineWidth(((Number)presProvider.getFloatStyleOrDefault(appearance, "width", Float.valueOf(1.0f))).intValue());
            return lineSeries;
        }

        private @NonNull ISeries<Integer> createDimmedSeriesFromModel(ISeriesModel yModel) {
            ISeriesSet seriesSet = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet();
            String seriesName = String.valueOf(yModel.getName()) + TmfCommonXAxisChartViewer.DIMMED_SERIES_SUFFIX;
            OutputElementStyle appearance = TmfCommonXAxisChartViewer.this.getSeriesStyle(yModel.getId());
            BaseXYPresentationProvider presProvider = TmfCommonXAxisChartViewer.this.getPresentationProvider();
            String type = (String)presProvider.getStyleOrDefault(appearance, "series-type", "line");
            RGBAColor rgbaColor = presProvider.getColorStyleOrDefault(appearance, "color", DEFAULT_COLOR);
            float[] rgb = rgbaColor.getHSBA();
            COLOR_REGISTRY.put(rgb.toString(), new RGBA((float)rgb[0], (float)(rgb[1] * 0.5f), (float)(rgb[2] * 0.5f), (float)rgb[3]).rgb);
            Color color = COLOR_REGISTRY.get(rgb.toString());
            String symbolType = (String)presProvider.getStyle(appearance, "symbol-type");
            if (type.equals("bar")) {
                IBarSeries barSeries = (IBarSeries)seriesSet.createSeries(ISeries.SeriesType.BAR, seriesName);
                barSeries.setBarColor(color);
                barSeries.setBarPadding(0);
                barSeries.setVisible(true);
                return barSeries;
            }
            ILineSeries lineSeries = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
            lineSeries.enableArea("area".equals(type));
            lineSeries.setLineStyle(LineStyle.valueOf((String)((String)presProvider.getStyleOrDefault(appearance, "series-style", "SOLID"))));
            lineSeries.setSymbolType(SYMBOL_MAP.getOrDefault(symbolType, ILineSeries.PlotSymbolType.NONE));
            lineSeries.setSymbolSize(Math.round(presProvider.getFloatStyleOrDefault(appearance, "height", Float.valueOf(1.0f)).floatValue() * 4.0f));
            lineSeries.setLineColor(color);
            lineSeries.setSymbolColor(color);
            lineSeries.setVisible(true);
            lineSeries.setLineWidth(((Number)presProvider.getFloatStyleOrDefault(appearance, "width", Float.valueOf(1.0f))).intValue());
            return lineSeries;
        }

        private void enableStack(ISeries<?> series, boolean stacked) {
            if (series.getType().equals((Object)ISeries.SeriesType.BAR)) {
                ((IBarSeries)series).enableStack(stacked);
            }
        }

        private synchronized void updateThreadFinished(UpdateThread thread) {
            if (thread == TmfCommonXAxisChartViewer.this.fUpdateThread) {
                TmfCommonXAxisChartViewer.this.fUpdateThread = null;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private /* synthetic */ void lambda$0(TraceCompassLogUtils.FlowScopeLog var1_1, IProgressMonitor var2_2, ITmfXyModel var3_3) {
            tmfChartTimeStampFormat = new TmfChartTimeStampFormat(TmfCommonXAxisChartViewer.this.getTimeOffset());
            xAxisDescription = null;
            yAxisDescription = null;
            var7_7 = null;
            var8_9 = null;
            try {
                block45: {
                    block46: {
                        block48: {
                            block47: {
                                block43: {
                                    block44: {
                                        block41: {
                                            block42: {
                                                block39: {
                                                    block40: {
                                                        log = new TraceCompassLogUtils.FlowScopeLogBuilder(TmfCommonXAxisChartViewer.access$0(), Level.FINE, "TmfCommonXAxisChart:UpdateDisplay", new Object[0]).setParentScope(var1_1).build();
                                                        if (this.fTrace.equals(TmfCommonXAxisChartViewer.this.getTrace())) break block39;
                                                        if (log == null) break block40;
                                                        log.close();
                                                    }
                                                    if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() >= 0) return;
                                                    Activator.getDefault().logError("Dirty underflow error", new Throwable());
                                                    return;
                                                }
                                                if (!TmfCommonXAxisChartViewer.this.getSwtChart().isDisposed()) break block41;
                                                if (log == null) break block42;
                                                log.close();
                                            }
                                            if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() >= 0) return;
                                            Activator.getDefault().logError("Dirty underflow error", new Throwable());
                                            return;
                                        }
                                        if (var2_2 == null || !var2_2.isCanceled()) break block43;
                                        if (log == null) break block44;
                                        log.close();
                                    }
                                    if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() >= 0) return;
                                    Activator.getDefault().logError("Dirty underflow error", new Throwable());
                                    return;
                                }
                                maxy = 4.9E-324;
                                miny = 1.7976931348623157E308;
                                delta = TmfCommonXAxisChartViewer.this.getWindowEndTime() - TmfCommonXAxisChartViewer.this.getWindowStartTime();
                                if (delta <= 0L) break block47;
                                var17_15 = var3_3.getSeriesData().iterator();
                                if (true) ** GOTO lbl116
                            }
                            TmfCommonXAxisChartViewer.this.clearContent();
                            delta = 1L;
                            break block48;
                            do {
                                entry = (ISeriesModel)var17_15.next();
                                extractXValuesToDisplay = this.extractXValuesToDisplay(entry.getXAxis());
                                dimmedX = new ArrayList<Double>(extractXValuesToDisplay.length);
                                dimmedY = new ArrayList<Double>(extractXValuesToDisplay.length);
                                brightX = new ArrayList<Double>(extractXValuesToDisplay.length);
                                brightY = new ArrayList<Double>(extractXValuesToDisplay.length);
                                propertiesArray = entry.getProperties();
                                data = entry.getData();
                                i = 0;
                                while (i < extractXValuesToDisplay.length) {
                                    value = data[i];
                                    maxy = Math.max(maxy, value);
                                    miny = Math.min(miny, value);
                                    v0 = properties = i < propertiesArray.length ? propertiesArray[i] : 0;
                                    if ((properties & 4) == 0) {
                                        if ((properties & 1) == 0) {
                                            brightX.add(extractXValuesToDisplay[i]);
                                            brightY.add(value);
                                        } else {
                                            dimmedX.add(extractXValuesToDisplay[i]);
                                            dimmedY.add(value);
                                        }
                                    }
                                    ++i;
                                }
                                brightXArray = new double[brightX.size()];
                                brightYArray = new double[brightY.size()];
                                i = 0;
                                while (i < brightX.size()) {
                                    brightXArray[i] = (Double)brightX.get(i);
                                    brightYArray[i] = (Double)brightY.get(i);
                                    ++i;
                                }
                                dimmedXArray = new double[dimmedX.size()];
                                dimmedYArray = new double[dimmedY.size()];
                                i = 0;
                                while (i < dimmedX.size()) {
                                    dimmedXArray[i] = (Double)dimmedX.get(i);
                                    dimmedYArray[i] = (Double)dimmedY.get(i);
                                    ++i;
                                }
                                if (xAxisDescription == null) {
                                    xAxisDescription = entry.getXAxisDescription();
                                }
                                if (yAxisDescription == null) {
                                    yAxisDescription = entry.getYAxisDescription();
                                }
                                seriesSet = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet();
                                series = seriesSet.getSeries(entry.getName());
                                dimmedSeries = seriesSet.getSeries(String.valueOf(entry.getName()) + ".dimmed");
                                if (brightX.isEmpty()) {
                                    if (series != null) {
                                        seriesSet.deleteSeries(entry.getName());
                                    }
                                } else {
                                    if (series == null) {
                                        series = this.createSWTSeriesFromModel(entry);
                                    }
                                    series.setDataModel((CartesianSeriesModel)new DoubleArraySeriesModel(brightXArray, brightYArray));
                                    this.enableStack(series, true);
                                }
                                if (dimmedX.isEmpty()) {
                                    if (dimmedSeries == null) continue;
                                    seriesSet.deleteSeries(String.valueOf(entry.getName()) + ".dimmed");
                                    continue;
                                }
                                if (dimmedSeries == null) {
                                    dimmedSeries = this.createDimmedSeriesFromModel(entry);
                                }
                                dimmedSeries.setDataModel((CartesianSeriesModel)new DoubleArraySeriesModel(dimmedXArray, dimmedYArray));
                                this.enableStack(dimmedSeries, true);
lbl116:
                                // 4 sources

                            } while (var17_15.hasNext());
                            maxy = maxy == 4.9E-324 ? 1.0 : maxy;
                        }
                        axisSet = TmfCommonXAxisChartViewer.this.getSwtChart().getAxisSet();
                        xTick = axisSet.getXAxis(0).getTick();
                        xFormatter = xAxisDescription != null ? DataTypeUtils.getFormat((DataType)xAxisDescription.getDataType(), (String)xAxisDescription.getUnit()) : null;
                        xTick.setFormat(xFormatter == null ? tmfChartTimeStampFormat : xFormatter);
                        if (yAxisDescription != null) {
                            format = axisSet.getYAxis(0).getTick().getFormat();
                            if (format == null) {
                                axisSet.getYAxis(0).getTick().setFormat(DataTypeUtils.getFormat((DataType)yAxisDescription.getDataType(), (String)yAxisDescription.getUnit()));
                            }
                            if (!(title = axisSet.getYAxis(0).getTitle()).isVisible()) {
                                title.setText(yAxisDescription.getLabel());
                                title.setVisible(true);
                            }
                        }
                        axisSet.getXAxis(0).setRange(new Range(1.0, 1.0 + (double)delta));
                        fixedYRange = TmfCommonXAxisChartViewer.this.getFixedYRange();
                        if (fixedYRange == null) {
                            axisSet.getYAxis(0).adjustRange();
                        } else {
                            axisSet.getYAxis(0).setRange(new Range(fixedYRange.getLower(), fixedYRange.getUpper()));
                        }
                        TmfCommonXAxisChartViewer.this.getSwtChart().redraw();
                        if (TmfCommonXAxisChartViewer.this.isSendTimeAlignSignals() == false) return;
                        parent = TmfCommonXAxisChartViewer.this.getParent();
                        if (parent != null && parent.getParent() != null) break block45;
                        if (log == null) break block46;
                        {
                            catch (Throwable var7_8) {
                                throw var7_8;
                            }
                        }
                        log.close();
                    }
                    if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() >= 0) return;
                    Activator.getDefault().logError("Dirty underflow error", new Throwable());
                    return;
                }
                viewPos = parent.getParent().toDisplay(0, 0);
                axisPos = TmfCommonXAxisChartViewer.this.getSwtChart().toDisplay((int)0, (int)0).x + TmfCommonXAxisChartViewer.this.getPointAreaOffset();
                timeAxisOffset = axisPos - viewPos.x;
                timeAlignmentInfo = new TmfTimeViewAlignmentInfo(TmfCommonXAxisChartViewer.this.getControl().getShell(), viewPos, timeAxisOffset);
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(TmfCommonXAxisChartViewer.this, timeAlignmentInfo, true));
                return;
            }
            catch (Throwable var8_10) {
                if (var7_7 == null) {
                    var7_7 = var8_10;
                    throw var7_7;
                }
                if (var7_7 == var8_10) throw var7_7;
                var7_7.addSuppressed(var8_10);
                throw var7_7;
            }
            {
                finally {
                    if (log != null) {
                        log.close();
                    }
                }
            }
        }
    }
}

