/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import org.eclipse.jface.action.Action;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.TimeGraphFindDialog;
import org.eclipse.ui.IWorkbenchPart;

class ShowFindDialogAction
extends Action {
    private static TimeGraphFindDialog fDialog;
    private AbstractTimeGraphView.FindTarget fFindTarget;

    public ShowFindDialogAction() {
        this.setText(Messages.ShowFindDialogAction_Search);
        this.setToolTipText(Messages.ShowFindDialogAction_ShowSearchDialog);
        this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/search.gif"));
    }

    public void run() {
        AbstractTimeGraphView.FindTarget findTarget = this.fFindTarget;
        if (findTarget == null) {
            return;
        }
        this.checkShell(findTarget);
        if (fDialog == null) {
            fDialog = new TimeGraphFindDialog(findTarget.getShell());
        }
        if (fDialog != null) {
            fDialog.update(findTarget);
            fDialog.open();
        }
    }

    public void checkShell(AbstractTimeGraphView.FindTarget target) {
        if (fDialog != null && !fDialog.isDialogParentShell(target.getShell())) {
            fDialog.close();
            fDialog = null;
        }
    }

    public synchronized void partActivated(IWorkbenchPart part) {
        AbstractTimeGraphView.FindTarget newTarget = null;
        if (part instanceof AbstractTimeGraphView && (newTarget = ((AbstractTimeGraphView)part).getFindTarget()) != this.fFindTarget) {
            this.fFindTarget = newTarget;
        }
        if (fDialog != null) {
            fDialog.updateTarget(newTarget, false);
        }
    }
}

