/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.osgi.service.prefs.Preferences;

public class LastAutoCheckForUpdateMemo {
    private static final String LAST_CHECK_FOR_UPDATE__DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final Preferences prefs;

    public LastAutoCheckForUpdateMemo(IAgentLocation agentLocation) {
        this.prefs = new ProfileScope(agentLocation, "_SELF_").getNode("org.eclipse.equinox.p2.ui.sdk.scheduler");
    }

    public Date store(Date datetime) {
        this.prefs.put("lastAutoCheckForUpdates", LastAutoCheckForUpdateMemo.toString(datetime));
        return datetime;
    }

    public Date readAndStoreIfAbsent(Date toStore) {
        Date date = this.read();
        if (date == null) {
            return this.store(toStore);
        }
        return date;
    }

    public Date read() {
        String lastCheckDateString = this.prefs.get("lastAutoCheckForUpdates", null);
        if (lastCheckDateString == null || lastCheckDateString.length() == 0) {
            return null;
        }
        return LastAutoCheckForUpdateMemo.valueOf(lastCheckDateString);
    }

    private static String toString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LAST_CHECK_FOR_UPDATE__DATE_FORMAT, Locale.US);
        return dateFormat.format(date);
    }

    private static Date valueOf(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LAST_CHECK_FOR_UPDATE__DATE_FORMAT, Locale.US);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            AutomaticUpdatePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.sdk.scheduler", e.getMessage(), (Throwable)e));
            return null;
        }
    }
}

