/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationDataProvider;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class CConfigurationDataProviderDescriptor {
    static final String DATA_PROVIDER_EXTPOINT_ID = "org.eclipse.cdt.core.CConfigurationDataProvider";
    static final String DATA_PROVIDER = "provider";
    static final String CLASS = "class";
    static final String NATURES = "natures";
    static final String CONFLICTING_NATURES = "conflictingNatures";
    static final String ECLIPSE_BUILDERS = "eclipseBuilders";
    static final String DELIMITER = ";";
    private String fId;
    private CConfigurationDataProvider fProvider;
    private IExtension fExtension;
    private IConfigurationElement fProviderElement;
    private String[] fNatureIds;
    private String[] fConflictingNatureIds;

    public CConfigurationDataProviderDescriptor(IExtension extension) {
        this.fId = extension.getUniqueIdentifier();
        this.fExtension = extension;
        this.fProviderElement = CConfigurationDataProviderDescriptor.getProviderElement(extension);
        if (this.fProviderElement != null) {
            this.fNatureIds = CConfigurationDataProviderDescriptor.toArray(this.fProviderElement.getAttribute(NATURES));
            this.fConflictingNatureIds = CConfigurationDataProviderDescriptor.toArray(this.fProviderElement.getAttribute(CONFLICTING_NATURES));
        } else {
            this.fNatureIds = new String[0];
            this.fConflictingNatureIds = new String[0];
        }
        try {
            this.fProvider = CConfigurationDataProviderDescriptor.createProvider(extension);
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    private static String[] toArray(String value) {
        if (value == null) {
            return new String[0];
        }
        StringTokenizer t = new StringTokenizer(value, DELIMITER);
        int num = t.countTokens();
        ArrayList<String> list = new ArrayList<String>(num);
        int i = 0;
        while (i < num) {
            String v = t.nextToken().trim();
            if (v.length() != 0) {
                list.add(v);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public CConfigurationDataProvider getProvider() throws CoreException {
        if (this.fProvider == null) {
            this.fProvider = CConfigurationDataProviderDescriptor.createProvider(this.fExtension);
        }
        return this.fProvider;
    }

    private static IConfigurationElement getProviderElement(IExtension ext) {
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (DATA_PROVIDER.equals(element.getName())) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private static CConfigurationDataProvider createProvider(IExtension ext) throws CoreException {
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (DATA_PROVIDER.equals(element.getName())) {
                Object obj = element.createExecutableExtension(CLASS);
                if (obj instanceof CConfigurationDataProvider) {
                    return (CConfigurationDataProvider)obj;
                }
                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CConfigurationDataProviderDescriptor.1"));
            }
            ++i;
        }
        throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CConfigurationDataProviderDescriptor.2"));
    }

    public String getId() {
        return this.fId;
    }

    public String[] getNatureIds() {
        return (String[])this.fNatureIds.clone();
    }

    public String[] getConflictingNatureIds() {
        return (String[])this.fConflictingNatureIds.clone();
    }
}

