/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.widgets.piechart;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.widgets.piechart.PieSlice;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.QualitativePaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class TmfPieChart
extends Chart {
    private static final Color BLACK = Display.getDefault().getSystemColor(2);
    private static final Color WHITE = Display.getDefault().getSystemColor(1);
    private static final String FONT = "Arial";
    private static final int NUM_COLORS = 23;
    private static final IPaletteProvider PALETTE = new QualitativePaletteProvider.Builder().setNbColors(23).build();
    private static final ColorRegistry REGISTRY = new ColorRegistry();
    private static final int X_GAP = 10;
    private Point fCenter = new Point(0, 0);
    private int fCurrentColor = 0;
    private String fSelectedId;
    private int[] fEndAngles;
    private List<PieSlice> fSlices = new ArrayList<PieSlice>();
    private int fWidth;

    public TmfPieChart(Composite parent, int style) {
        super(parent, style);
        this.fSlices.clear();
        IAxis[] iAxisArray = this.getAxisSet().getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.getTitle().setVisible(false);
            axis.getTick().setVisible(false);
            ++n2;
        }
        IPlotArea plotArea = this.getPlotArea();
        Chart chart = plotArea.getChart();
        ((Composite)plotArea).setVisible(false);
        chart.addPaintListener((PaintListener)new PiePaintListener());
        REGISTRY.put(Messages.TmfStatisticsView_PieChartOthersSliceName, new RGB(128, 128, 128));
    }

    public void addPieSlice(String label, double value, String id) {
        PieSlice pieSlice = new PieSlice(label, value, id);
        IBarSeries bs = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, id);
        Color sliceColor = REGISTRY.get(id);
        if (sliceColor == null) {
            this.fCurrentColor += 3;
            RGBAColor rgba = (RGBAColor)PALETTE.get().get(this.fCurrentColor % 23);
            REGISTRY.put(id, new RGB((int)rgba.getRed(), (int)rgba.getGreen(), (int)rgba.getBlue()));
            sliceColor = REGISTRY.get(id);
        }
        bs.setBarColor(sliceColor);
        this.fSlices.add(pieSlice);
    }

    public void clear() {
        for (PieSlice slice : this.fSlices) {
            this.getSeriesSet().deleteSeries(slice.getID());
        }
        this.fSlices.clear();
    }

    public PieSlice getSliceFromPosition(int x, int y) {
        double rad = Math.sqrt(Math.pow(this.fCenter.x - x, 2.0) + Math.pow(this.fCenter.y - y, 2.0));
        if (2.0 * rad > (double)this.fWidth) {
            return null;
        }
        double angle = Math.acos((double)(this.fCenter.y - y) / rad) / Math.PI * 180.0;
        if (x - this.fCenter.x < 0) {
            angle = 360.0 - angle;
        }
        if (this.fEndAngles.length == 0 || angle < (double)this.fEndAngles[0]) {
            return this.fSlices.get(0);
        }
        int s = 0;
        while (s < this.fEndAngles.length - 1) {
            if ((double)this.fEndAngles[s] <= angle && angle < (double)this.fEndAngles[s + 1]) {
                return this.fSlices.get(s + 1);
            }
            ++s;
        }
        return this.fSlices.get(this.fSlices.size() - 1);
    }

    public double getTotal() {
        return this.fSlices.stream().collect(Collectors.summingDouble(PieSlice::getValue));
    }

    public void select(String id) {
        this.fSelectedId = id;
    }

    public void addColor(String sliceId, @NonNull RGB color) {
        REGISTRY.put(sliceId, color);
    }

    private final class PiePaintListener
    implements PaintListener {
        private PiePaintListener() {
        }

        private void drawPieChart(PaintEvent e, Rectangle bounds) {
            int nbSeries = TmfPieChart.this.fSlices.size();
            TmfPieChart.this.fEndAngles = new int[nbSeries - 1];
            double selectAngle1 = Double.NaN;
            double selectAngle2 = Double.NaN;
            double sumTotal = TmfPieChart.this.getTotal();
            GC gc = e.gc;
            Color prevFg = gc.getForeground();
            Color prevBg = gc.getBackground();
            gc.setForeground(BLACK);
            gc.setLineWidth(1);
            gc.setAntialias(1);
            int pieX = bounds.x + (bounds.width - TmfPieChart.this.fWidth) / 2;
            int pieY = bounds.y + (bounds.height - TmfPieChart.this.fWidth) / 2;
            TmfPieChart.this.fCenter = new Point(pieX + TmfPieChart.this.fWidth / 2, pieY + TmfPieChart.this.fWidth / 2);
            if (sumTotal == 0.0) {
                gc.drawOval(pieX, pieY, TmfPieChart.this.fWidth, TmfPieChart.this.fWidth);
            } else {
                double factor = 100.0 / sumTotal;
                int arcAngle = 0;
                int currentAngle = 90;
                int i = 0;
                while (i < nbSeries) {
                    PieSlice pieSlice = (PieSlice)TmfPieChart.this.fSlices.get(i);
                    if (i > 0) {
                        ((TmfPieChart)TmfPieChart.this).fEndAngles[i - 1] = 90 - currentAngle;
                    }
                    IBarSeries series = (IBarSeries)TmfPieChart.this.getSeriesSet().getSeries(pieSlice.getID());
                    Color bgColor = series.getBarColor();
                    gc.setBackground(bgColor);
                    if (i == nbSeries - 1) {
                        arcAngle = currentAngle - -270;
                    } else {
                        double angle = pieSlice.getValue() * factor * 3.6;
                        arcAngle = (int)Math.round(angle);
                    }
                    if (Objects.equals(pieSlice.getID(), TmfPieChart.this.fSelectedId)) {
                        gc.setLineWidth(3);
                        gc.setForeground(BLACK);
                        selectAngle1 = currentAngle;
                        selectAngle2 = currentAngle - arcAngle;
                    } else {
                        gc.setForeground(WHITE);
                        gc.setLineWidth(2);
                        int prevAlpha = gc.getAlpha();
                        gc.setAlpha(80);
                        this.drawRadius(gc, TmfPieChart.this.fCenter, (double)TmfPieChart.this.fWidth * 0.5, currentAngle);
                        this.drawRadius(gc, TmfPieChart.this.fCenter, (double)TmfPieChart.this.fWidth * 0.5, currentAngle - arcAngle);
                        gc.setAlpha(prevAlpha);
                    }
                    gc.fillArc(pieX, pieY, TmfPieChart.this.fWidth, TmfPieChart.this.fWidth, currentAngle, -arcAngle);
                    currentAngle -= arcAngle;
                    gc.setLineWidth(1);
                    ++i;
                }
                gc.setForeground(BLACK);
            }
            if (!Double.isNaN(selectAngle1) && !Double.isNaN(selectAngle2)) {
                gc.setLineWidth(2);
                this.drawRadius(gc, TmfPieChart.this.fCenter, (double)TmfPieChart.this.fWidth * 0.5, selectAngle1);
                this.drawRadius(gc, TmfPieChart.this.fCenter, (double)TmfPieChart.this.fWidth * 0.5, selectAngle2);
                gc.drawArc(pieX, pieY, TmfPieChart.this.fWidth, TmfPieChart.this.fWidth, (int)selectAngle1, (int)(selectAngle2 - selectAngle1));
                gc.setLineWidth(1);
            }
            gc.setForeground(prevFg);
            gc.setBackground(prevBg);
        }

        private void drawRadius(GC gc, Point center, double radius, double angle) {
            double radians = Math.toRadians(-angle);
            gc.drawLine(center.x, center.y, (int)Math.round((double)center.x + Math.cos(radians) * radius), (int)Math.round((double)center.y + Math.sin(radians) * radius));
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            IPlotArea canvas = TmfPieChart.this.getPlotArea();
            Chart chart = canvas.getChart();
            Rectangle bounds = canvas.getControl().getBounds();
            TmfPieChart.this.fCenter = new Point(bounds.x + bounds.width / 2, bounds.height / 2 + bounds.y);
            TmfPieChart.this.fEndAngles = new int[TmfPieChart.this.fSlices.size()];
            if (TmfPieChart.this.fSlices.isEmpty()) {
                bounds = gc.getClipping();
                Font oldFont = gc.getFont();
                Font font = new Font((Device)Display.getDefault(), TmfPieChart.FONT, 15, 1);
                gc.setForeground(BLACK);
                gc.setFont(font);
                String text = Messages.TmfPieChart_noData;
                Point textSize = e.gc.textExtent(text);
                gc.drawText(text, (bounds.width - textSize.x) / 2, (bounds.height - textSize.y) / 2);
                gc.setFont(oldFont);
                font.dispose();
                return;
            }
            int width = bounds.width;
            int x = bounds.x;
            if (chart.getLegend().isVisible()) {
                Rectangle legendBounds = ((Control)chart.getLegend()).getBounds();
                Font oldFont = gc.getFont();
                Font font = new Font((Device)Display.getDefault(), TmfPieChart.FONT, 10, 1);
                gc.setForeground(BLACK);
                gc.setFont(font);
                String text = chart.getAxisSet().getXAxis(0).getTitle().getText();
                Point textSize = e.gc.textExtent(text);
                gc.drawText(text, legendBounds.x + (legendBounds.width - textSize.x) / 2, legendBounds.y - textSize.y);
                gc.setFont(oldFont);
                font.dispose();
            }
            TmfPieChart.this.fWidth = Math.min(width - 10, bounds.height);
            this.drawPieChart(e, new Rectangle(x, bounds.y, width, bounds.height));
        }
    }
}

