/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentInputStream
extends InputStream {
    private IDocument fDocument;
    private int fMark = -1;
    private int fPosition = 0;

    public DocumentInputStream(IDocument source) {
        this.fDocument = source;
    }

    @Override
    public int available() throws IOException {
        return this.fDocument.getLength() - this.fPosition;
    }

    @Override
    public void close() throws IOException {
        this.fDocument = null;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.fMark = this.fPosition;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.fPosition < this.fDocument.getLength()) {
                return this.fDocument.getChar(this.fPosition++);
            }
            return -1;
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fPosition = this.fMark;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = n;
        if (n < (long)(this.fDocument.getLength() - this.fPosition)) {
            skipped = n;
            this.fPosition = (int)((long)this.fPosition + skipped);
        } else {
            skipped = this.fDocument.getLength() - this.fPosition;
            this.fPosition = this.fDocument.getLength();
        }
        return skipped;
    }
}

