/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.aspect;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.Messages;

public class TmfStateSystemAspect
implements ITmfEventAspect<String> {
    private final @Nullable String fName;
    private final ITmfStateSystem fSS;
    private final int fAttribute;

    public TmfStateSystemAspect(@Nullable String name, ITmfStateSystem ss, int attributeQuark) {
        this.fName = name;
        this.fSS = ss;
        this.fAttribute = attributeQuark;
    }

    @Override
    public String getName() {
        String name = this.fName;
        if (name != null) {
            return name;
        }
        name = this.fSS.getFullAttributePath(this.fAttribute);
        return name;
    }

    @Override
    public @NonNull String getHelpText() {
        return Messages.getMessage(NLS.bind((String)Messages.AspectHelpText_Statesystem, (Object)this.fSS.getSSID(), (Object)this.fSS.getFullAttributePath(this.fAttribute)));
    }

    @Override
    public @Nullable String resolve(ITmfEvent event) {
        try {
            ITmfStateValue value = this.fSS.querySingleState(event.getTimestamp().getValue(), this.fAttribute).getStateValue();
            return (String)NonNullUtils.checkNotNull((Object)value.toString());
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            return null;
        }
    }
}

