/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class PatternLatencyViewTestBase {
    private static final String PROJECT_NAME = "test";
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String TRACE_NAME = "bug446190";
    private static final Logger fLogger = Logger.getRootLogger();
    protected static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        WaitUtils.waitForJobs();
        fBot = new SWTWorkbenchBot();
        PatternLatencyViewTestBase.loadXmlFile();
        PatternLatencyViewTestBase.openTrace();
    }

    @AfterClass
    public static void afterClass() {
        fLogger.removeAllAppenders();
    }

    private static void openTrace() {
        try {
            String tracePath = FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL())).getAbsolutePath();
            SWTBotUtils.createProject((String)PROJECT_NAME);
            SWTBotUtils.openTrace((String)PROJECT_NAME, (String)tracePath, (String)TRACE_TYPE);
            WaitUtils.waitForJobs();
        }
        catch (IOException iOException) {
            Assert.fail((String)"Failed to get the trace.");
        }
    }

    private static void loadXmlFile() {
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.VALID_PATTERN_FILE.getFile());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    @Before
    public void before() {
        PatternLatencyViewTestBase.openView(this.getViewTitle());
    }

    @After
    public void closeView() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
        SWTBotUtils.closeViewById((String)this.getViewId(), (SWTWorkbenchBot)fBot);
    }

    private static void openView(String viewTitle) {
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)PROJECT_NAME);
        treeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTreeItem)treeItem, (String[])new String[]{TRACE_NAME, "Views", "XML system call analysis", viewTitle});
        treeItem.doubleClick();
        WaitUtils.waitForJobs();
    }

    protected abstract String getViewId();

    protected abstract String getViewTitle();
}

