/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.CompositeDebugImageDescriptor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.internal.ui.model.elements.DebugElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.model.IWorkbenchAdapter2;

public class BreakpointContainerLabelProvider
extends DebugElementLabelProvider {
    @Override
    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        ImageDescriptor desc = super.getImageDescriptor(elementPath, presentationContext, columnId);
        int flags = this.computeAdornmentFlags();
        if (flags > 0) {
            Image image = DebugUIPlugin.getImageDescriptorRegistry().get(desc);
            CompositeDebugImageDescriptor compDesc = new CompositeDebugImageDescriptor(image, flags);
            return compDesc;
        }
        return desc;
    }

    @Override
    public boolean getChecked(TreePath path, IPresentationContext presentationContext) throws CoreException {
        Object lastSegment = path.getLastSegment();
        if (lastSegment instanceof IBreakpointContainer) {
            IBreakpointContainer container = (IBreakpointContainer)lastSegment;
            IBreakpoint[] breakpoints = container.getBreakpoints();
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i].isEnabled()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return super.getChecked(path, presentationContext);
    }

    @Override
    public boolean getGrayed(TreePath path, IPresentationContext presentationContext) throws CoreException {
        Object lastSegment = path.getLastSegment();
        if (lastSegment instanceof IBreakpointContainer) {
            IBreakpointContainer container = (IBreakpointContainer)lastSegment;
            IBreakpoint[] breakpoints = container.getBreakpoints();
            boolean hasEnabled = false;
            boolean hasDisabled = false;
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i].isEnabled()) {
                    hasEnabled = true;
                } else {
                    hasDisabled = true;
                }
                if (hasEnabled && hasDisabled) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return super.getGrayed(path, presentationContext);
    }

    @Override
    protected FontData getFontData(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IWorkbenchAdapter2 adapter;
        Object element = elementPath.getLastSegment();
        FontData fontData = super.getFontData(elementPath, presentationContext, columnId);
        if (fontData == null && element instanceof IAdaptable && (adapter = (IWorkbenchAdapter2)((IAdaptable)element).getAdapter(IWorkbenchAdapter2.class)) != null) {
            fontData = adapter.getFont(element);
        }
        return fontData;
    }

    @Override
    protected RGB getForeground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IWorkbenchAdapter2 adapter;
        Object element = elementPath.getLastSegment();
        RGB rgb = super.getForeground(elementPath, presentationContext, columnId);
        if (rgb == null && element instanceof IAdaptable && (adapter = (IWorkbenchAdapter2)((IAdaptable)element).getAdapter(IWorkbenchAdapter2.class)) != null) {
            rgb = adapter.getForeground(element);
        }
        return rgb;
    }

    @Override
    protected RGB getBackground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IWorkbenchAdapter2 adapter;
        Object element = elementPath.getLastSegment();
        RGB rgb = super.getBackground(elementPath, presentationContext, columnId);
        if (rgb == null && element instanceof IAdaptable && (adapter = (IWorkbenchAdapter2)((IAdaptable)element).getAdapter(IWorkbenchAdapter2.class)) != null) {
            rgb = adapter.getBackground(element);
        }
        return rgb;
    }

    private int computeAdornmentFlags() {
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return 1;
        }
        return 0;
    }
}

