/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class ProcessConsoleManager
implements ILaunchListener {
    private Map<String, IConfigurationElement> fColorProviders;
    private IConsoleColorProvider fDefaultColorProvider;
    private Map<String, List<IConfigurationElement>> fLineTrackers;
    private Map<ILaunch, IProcess[]> fProcesses;
    private Object fLineTrackersLock = new Object();

    public void launchRemoved(ILaunch launch) {
        this.removeLaunch(launch);
    }

    protected void removeLaunch(ILaunch launch) {
        IProcess[] processes = launch.getProcesses();
        int i = 0;
        while (i < processes.length) {
            IProcess iProcess = processes[i];
            this.removeProcess(iProcess);
            ++i;
        }
        if (this.fProcesses != null) {
            this.fProcesses.remove(launch);
        }
    }

    private void removeProcess(IProcess iProcess) {
        IConsole console = this.getConsole(iProcess);
        if (console != null) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            manager.removeConsoles(new IConsole[]{console});
        }
    }

    public IConsole getConsole(IProcess process) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            ProcessConsole pc;
            IConsole console = consoles[i];
            if (console instanceof ProcessConsole && (pc = (ProcessConsole)console).getProcess().equals(process)) {
                return pc;
            }
            ++i;
        }
        return null;
    }

    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    public void launchChanged(ILaunch launch) {
        IProcess[] processes;
        IProcess[] iProcessArray = processes = launch.getProcesses();
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            if (process.getStreamsProxy() != null && this.getConsoleDocument(process) == null) {
                ConsoleCreation job = new ConsoleCreation(launch, process);
                job.schedule();
            }
            ++n2;
        }
        List<IProcess> removed = this.getRemovedProcesses(launch);
        if (removed != null) {
            for (IProcess p : removed) {
                this.removeProcess(p);
            }
        }
    }

    public IDocument getConsoleDocument(IProcess process) {
        ProcessConsole console = (ProcessConsole)this.getConsole(process);
        return console != null ? console.getDocument() : null;
    }

    public void startup() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            this.launchAdded(launches[i]);
            ++i;
        }
    }

    public void shutdown() {
        Job.getJobManager().cancel(ProcessConsoleManager.class);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            this.removeLaunch(launch);
            ++i;
        }
        launchManager.removeLaunchListener((ILaunchListener)this);
        if (this.fProcesses != null) {
            this.fProcesses.clear();
        }
    }

    public IConsoleColorProvider getColorProvider(String type) {
        IConfigurationElement extension;
        if (this.fColorProviders == null) {
            this.fColorProviders = new HashMap<String, IConfigurationElement>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "consoleColorProviders");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement extension2 = elements[i];
                this.fColorProviders.put(extension2.getAttribute("processType"), extension2);
                ++i;
            }
        }
        if ((extension = this.fColorProviders.get(type)) != null) {
            try {
                Object colorProvider = extension.createExecutableExtension("class");
                if (colorProvider instanceof IConsoleColorProvider) {
                    return (IConsoleColorProvider)colorProvider;
                }
                DebugUIPlugin.logErrorMessage(MessageFormat.format((String)"Extension {0} must specify an instanceof IConsoleColorProvider for class attribute.", (Object[])new Object[]{extension.getDeclaringExtension().getUniqueIdentifier()}));
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        if (this.fDefaultColorProvider == null) {
            this.fDefaultColorProvider = new ConsoleColorProvider();
        }
        return this.fDefaultColorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IConsoleLineTracker[] getLineTrackers(IProcess process) {
        IConfigurationElement[] elements;
        String type = process.getAttribute(IProcess.ATTR_PROCESS_TYPE);
        if (this.fLineTrackers == null) {
            Object object = this.fLineTrackersLock;
            synchronized (object) {
                this.fLineTrackers = new HashMap<String, List<IConfigurationElement>>();
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "consoleLineTrackers");
                elements = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement extension = elements[i];
                    String processType = extension.getAttribute("processType");
                    List<IConfigurationElement> list = this.fLineTrackers.get(processType);
                    if (list == null) {
                        list = new ArrayList<IConfigurationElement>();
                        this.fLineTrackers.put(processType, list);
                    }
                    list.add(extension);
                    ++i;
                }
            }
        }
        ArrayList<IConsoleLineTracker> trackers = new ArrayList<IConsoleLineTracker>();
        if (type == null) return trackers.toArray(new IConsoleLineTracker[0]);
        elements = this.fLineTrackers;
        synchronized (this.fLineTrackers) {
            List<IConfigurationElement> lineTrackerExtensions = this.fLineTrackers.get(type);
            // ** MonitorExit[elements] (shouldn't be in output)
            if (lineTrackerExtensions == null) return trackers.toArray(new IConsoleLineTracker[0]);
            for (IConfigurationElement element : lineTrackerExtensions) {
                try {
                    trackers.add((IConsoleLineTracker)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
            return trackers.toArray(new IConsoleLineTracker[0]);
        }
    }

    private List<IProcess> getRemovedProcesses(ILaunch launch) {
        ArrayList<IProcess> removed = null;
        if (this.fProcesses == null) {
            this.fProcesses = new HashMap<ILaunch, IProcess[]>();
        }
        IProcess[] old = this.fProcesses.get(launch);
        Object[] curr = launch.getProcesses();
        if (old != null) {
            int i = 0;
            while (i < old.length) {
                IProcess process = old[i];
                if (!this.contains(curr, process)) {
                    if (removed == null) {
                        removed = new ArrayList<IProcess>();
                    }
                    removed.add(process);
                }
                ++i;
            }
        }
        this.fProcesses.put(launch, (IProcess[])curr);
        return removed;
    }

    private boolean contains(Object[] list, Object object) {
        int i = 0;
        while (i < list.length) {
            Object object2 = list[i];
            if (object2.equals(object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final class ConsoleCreation
    extends Job {
        private final ILaunch launch;
        private final IProcess process;

        ConsoleCreation(ILaunch launch, IProcess process) {
            super("Creating console for " + process.getLabel());
            this.launch = launch;
            this.process = process;
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled() || ProcessConsoleManager.this.getConsoleDocument(this.process) != null) {
                return Status.CANCEL_STATUS;
            }
            IConsoleColorProvider colorProvider = ProcessConsoleManager.this.getColorProvider(this.process.getAttribute(IProcess.ATTR_PROCESS_TYPE));
            String encoding = this.launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
            ProcessConsole pc = new ProcessConsole(this.process, colorProvider, encoding);
            pc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS", this.process);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{pc});
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            if (!launchManager.isRegistered(this.launch)) {
                ProcessConsoleManager.this.removeLaunch(this.launch);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return this.process == family || ProcessConsoleManager.class == family;
        }

        public boolean shouldSchedule() {
            Job[] jobs;
            Job[] jobArray = jobs = Job.getJobManager().find((Object)this.process);
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job instanceof ConsoleCreation) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

