/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public final class KernelPidAspect
extends LinuxPidAspect {
    public static final KernelPidAspect INSTANCE = new KernelPidAspect();
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();

    private KernelPidAspect() {
    }

    @Override
    public @Nullable Integer resolve(ITmfEvent event) {
        try {
            return this.resolve(event, false, NULL_MONITOR);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public @Nullable Integer resolve(@NonNull ITmfEvent event, boolean block, IProgressMonitor monitor) throws InterruptedException {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return null;
        }
        KernelAnalysisModule analysis = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)event.getTrace(), KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (analysis == null) {
            return null;
        }
        long ts = event.getTimestamp().toNanos();
        while (block && !analysis.isQueryable(ts) && !monitor.isCanceled()) {
            Thread.sleep(100L);
        }
        return KernelThreadInformationProvider.getProcessId(analysis, tid, ts);
    }
}

