/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.internal.copy;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.swt.internal.copy.WorkbenchSWTMessages;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ViewLabelProvider
extends ColumnLabelProvider {
    private static final String FOLDER_ICON = "org.eclipse.e4.descriptor.folder";
    private Map<String, Image> imageMap = new HashMap<String, Image>();
    private IEclipseContext context;

    static {
        Path path;
        Bundle bundle = WorkbenchSWTActivator.getDefault().getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path("$nl$/icons/full/obj16/fldr_obj.png")), null);
        ImageDescriptor enabledDesc = ImageDescriptor.createFromURL((URL)url);
        if (enabledDesc != null) {
            JFaceResources.getImageRegistry().put(FOLDER_ICON, enabledDesc);
        }
    }

    public ViewLabelProvider(IEclipseContext context) {
        this.context = context;
    }

    public void dispose() {
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof MPartDescriptor) {
            String iconURI = ((MPartDescriptor)element).getIconURI();
            if (iconURI != null && iconURI.length() > 0) {
                Image image = this.imageMap.get(iconURI);
                if (image == null) {
                    ISWTResourceUtilities resUtils = (ISWTResourceUtilities)this.context.get(IResourceUtilities.class);
                    image = ((ImageDescriptor)resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))).createImage();
                    this.imageMap.put(iconURI, image);
                }
                return image;
            }
            return null;
        }
        if (element instanceof String) {
            Image image = this.imageMap.get(FOLDER_ICON);
            if (image == null) {
                image = JFaceResources.getImageRegistry().getDescriptor(FOLDER_ICON).createImage();
                this.imageMap.put(FOLDER_ICON, image);
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        String label = WorkbenchSWTMessages.ViewLabel_unknown;
        if (element instanceof String) {
            label = (String)element;
        } else if (element instanceof MPartDescriptor) {
            label = ((MPartDescriptor)element).getLocalizedLabel();
        }
        return label;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

