/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import java.util.Objects;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IAnnotation;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class MarkerEvent
extends TimeEvent
implements IMarkerEvent {
    private static final RGBAColor BLACK = new RGBAColor(0, 0, 0);
    private final String fCategory;
    private final RGBA fColor;
    private final String fLabel;
    private final boolean fForeground;

    public MarkerEvent(ITimeGraphEntry entry, long time, long duration, String category, RGBA color, String label, boolean foreground) {
        super(entry, time, duration);
        this.fCategory = category;
        this.fColor = color;
        this.fLabel = label;
        this.fForeground = foreground;
    }

    public MarkerEvent(ITimeGraphEntry entry, long time, long duration, String category, RGBA color, String label, boolean foreground, int value) {
        super(entry, time, duration, value);
        this.fCategory = category;
        this.fColor = color;
        this.fLabel = label;
        this.fForeground = foreground;
    }

    public MarkerEvent(IAnnotation annotation, ITimeGraphEntry entry, String category, boolean foreground) {
        super(entry, (ITimeElement)annotation);
        this.fCategory = category;
        this.fLabel = annotation.getLabel();
        OutputElementStyle style = annotation.getStyle();
        RGBAColor color = null;
        if (style != null) {
            StyleManager styleManager = StyleManager.empty();
            color = styleManager.getColorStyle(style, "color");
        }
        if (color == null) {
            color = BLACK;
        }
        this.fColor = new RGBA((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue(), (int)color.getAlpha());
        this.fForeground = foreground;
    }

    @Override
    public String getCategory() {
        return this.fCategory;
    }

    @Override
    public RGBA getColor() {
        return this.fColor;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public boolean isForeground() {
        return this.fForeground;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.getCategory(), this.getColor(), this.isForeground(), this.getLabel());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkerEvent other = (MarkerEvent)obj;
        return Objects.equals(this.getCategory(), other.getCategory()) && Objects.equals(this.getColor(), other.getColor()) && this.isForeground() == other.isForeground() && Objects.equals(this.getLabel(), other.getLabel());
    }
}

