/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.histogram;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.histogram.HistogramDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.histogram.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class HistogramDataProviderFactory
implements IDataProviderFactory {
    private static final IDataProviderDescriptor DESCRIPTOR = new DataProviderDescriptor.Builder().setId("org.eclipse.tracecompass.internal.tmf.core.histogram.HistogramDataProvider").setName(NonNullUtils.nullToEmptyString((Object)Messages.HistogramDataProvider_Title)).setDescription(NonNullUtils.nullToEmptyString((Object)Messages.HistogramDataProviderFactory_DescriptionText)).setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY).build();

    public @Nullable ITmfTreeXYDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        TmfStatisticsModule statsMod;
        Collection<ITmfTrace> traces = TmfTraceManager.getTraceSet(trace);
        if (traces.size() == 1 && (statsMod = TmfTraceUtils.getAnalysisModuleOfClass(trace, TmfStatisticsModule.class, "org.eclipse.linuxtools.tmf.core.statistics.analysis")) != null) {
            statsMod.schedule();
            return new HistogramDataProvider(trace, statsMod);
        }
        return TmfTreeXYCompositeDataProvider.create(traces, HistogramDataProvider.TITLE, "org.eclipse.tracecompass.internal.tmf.core.histogram.HistogramDataProvider");
    }

    @Override
    public Collection<IDataProviderDescriptor> getDescriptors(@NonNull ITmfTrace trace) {
        return Collections.singletonList(DESCRIPTOR);
    }
}

