/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem.StateSystemTest;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StateSystemFullHistoryTest
extends StateSystemTest {
    private static final @NonNull String TEST_FILE_NAME = "test.ht";
    private static final @NonNull String BENCHMARK_FILE_NAME = "test.benchmark.ht";
    private static CtfTmfTrace trace;
    private static File stateFile;
    private static File stateFileBenchmark;
    private static TestLttngKernelAnalysisModule module;

    @BeforeClass
    public static void initialize() {
        trace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace);
        stateFile = StateSystemFullHistoryTest.createStateFile(TEST_FILE_NAME);
        stateFileBenchmark = StateSystemFullHistoryTest.createStateFile(BENCHMARK_FILE_NAME);
        module = new TestLttngKernelAnalysisModule(TEST_FILE_NAME);
        try {
            Assert.assertTrue((boolean)module.setTrace((ITmfTrace)trace));
        }
        catch (TmfAnalysisException tmfAnalysisException) {
            Assert.fail();
        }
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        fixture = module.getStateSystem();
    }

    @AfterClass
    public static void cleanup() {
        if (module != null) {
            module.dispose();
        }
        if (stateFile != null) {
            stateFile.delete();
        }
        if (stateFileBenchmark != null) {
            stateFileBenchmark.delete();
        }
        if (fixture != null) {
            fixture.dispose();
        }
        if (trace != null) {
            trace.dispose();
        }
        module = null;
        fixture = null;
        trace = null;
    }

    @Test
    public void testBuild() {
        TestLttngKernelAnalysisModule module2 = new TestLttngKernelAnalysisModule(BENCHMARK_FILE_NAME);
        try {
            Assert.assertTrue((boolean)module2.setTrace((ITmfTrace)trace));
        }
        catch (TmfAnalysisException tmfAnalysisException) {
            module2.dispose();
            Assert.fail();
        }
        module2.schedule();
        Assert.assertTrue((boolean)module2.waitForCompletion());
        ITmfStateSystem ssb2 = module2.getStateSystem();
        Assert.assertNotNull((Object)ssb2);
        Assert.assertEquals((long)1331668247314038062L, (long)ssb2.getStartTime());
        Assert.assertEquals((long)1331668259054285979L, (long)ssb2.getCurrentEndTime());
        module2.dispose();
    }

    @Test
    public void testOpenExistingStateFile() {
        TestLttngKernelAnalysisModule module2 = new TestLttngKernelAnalysisModule(TEST_FILE_NAME);
        try {
            Assert.assertTrue((boolean)module2.setTrace((ITmfTrace)trace));
        }
        catch (TmfAnalysisException tmfAnalysisException) {
            module2.dispose();
            Assert.fail();
        }
        module2.schedule();
        Assert.assertTrue((boolean)module2.waitForCompletion());
        ITmfStateSystem ssb2 = module2.getStateSystem();
        Assert.assertNotNull((Object)ssb2);
        Assert.assertEquals((long)1331668247314038062L, (long)ssb2.getStartTime());
        Assert.assertEquals((long)1331668259054285979L, (long)ssb2.getCurrentEndTime());
        module2.dispose();
    }

    private static File createStateFile(String name) {
        File file = new File(String.valueOf(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace)) + name);
        if (file.exists()) {
            file.delete();
        }
        return file;
    }

    @NonNullByDefault
    private static class TestLttngKernelAnalysisModule
    extends KernelAnalysisModule {
        private final String htFileName;

        public TestLttngKernelAnalysisModule(String htFileName) {
            this.htFileName = htFileName;
        }

        public boolean setTrace(@Nullable ITmfTrace trace) throws TmfAnalysisException {
            if (!(trace instanceof CtfTmfTrace)) {
                return false;
            }
            return super.setTrace(trace);
        }

        protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
            return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
        }

        protected String getSsFileName() {
            return this.htFileName;
        }
    }
}

