/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swtchart.Chart;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.IPieChartViewerState;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.PieChartViewerStateNoContentSelected;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.model.TmfPieChartStatisticsModel;
import org.eclipse.tracecompass.internal.tmf.ui.widgets.piechart.PieSlice;
import org.eclipse.tracecompass.internal.tmf.ui.widgets.piechart.TmfPieChart;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;

public class TmfPieChartViewer
extends Composite {
    private static final Comparator<EventOccurrenceObject> COMPARATOR = Comparator.comparing(EventOccurrenceObject::getNbOccurence).reversed();
    private static final float MIN_PRECENTAGE_TO_SHOW_SLICE = 0.025f;
    private static final int NB_MAX_SLICES = 10;
    private @NonNull TimeGraphColorScheme fColorScheme = new TimeGraphColorScheme();
    private IPieChartViewerState fCurrentState;
    private ListenerList<Listener> fEventTypeSelectedListeners = new ListenerList(1);
    private TmfPieChart fGlobalPC;
    private String fGlobalPCname = Messages.TmfStatisticsView_GlobalSelectionPieChartName;
    private TmfPieChartStatisticsModel fModel = null;
    private MouseListener fMouseClickListener;
    private Listener fMouseMoveListener;
    private String fOthersSliceName;
    private PieSlice fSelected = null;
    private TmfPieChart fTimeRangePC;
    private String fTimeRangePCname = Messages.TmfStatisticsView_TimeRangeSelectionPieChartName;

    private static void updatePieChartWithData(TmfPieChart chart, Map<String, Long> slices, float minimumSizeOfSlice, String nameOfOthers) {
        ArrayList<EventOccurrenceObject> chartValues = new ArrayList<EventOccurrenceObject>();
        Long eventTotal = 0L;
        for (Map.Entry<String, Long> entry : slices.entrySet()) {
            eventTotal = eventTotal + entry.getValue();
            chartValues.add(new EventOccurrenceObject(entry.getKey(), entry.getValue(), entry.getKey()));
        }
        if (eventTotal == 0L) {
            return;
        }
        ArrayList<EventOccurrenceObject> filteredChartValues = new ArrayList<EventOccurrenceObject>();
        Long othersEntryCount = 0L;
        int nbSlices = 0;
        for (EventOccurrenceObject entry : chartValues) {
            if ((float)entry.getNbOccurence().longValue() / eventTotal.floatValue() > minimumSizeOfSlice && nbSlices <= 10) {
                filteredChartValues.add(entry);
                ++nbSlices;
                continue;
            }
            othersEntryCount = othersEntryCount + entry.getNbOccurence();
        }
        Collections.sort(filteredChartValues, COMPARATOR);
        if (othersEntryCount != 0L) {
            filteredChartValues.add(new EventOccurrenceObject(nameOfOthers, othersEntryCount, nameOfOthers));
        }
        chart.clear();
        for (EventOccurrenceObject entry : filteredChartValues) {
            chart.addPieSlice(entry.getName(), entry.getNbOccurence().longValue(), entry.getId());
        }
        chart.redraw();
    }

    public TmfPieChartViewer(Composite parent) {
        super(parent, 0);
        this.fOthersSliceName = Messages.TmfStatisticsView_PieChartOthersSliceName;
        parent.addDisposeListener(e -> this.fColorScheme.dispose());
        this.initContent();
    }

    public void addEventTypeSelectionListener(Listener l) {
        this.fEventTypeSelectedListeners.add((Object)l);
    }

    synchronized IPieChartViewerState getCurrentState() {
        return this.fCurrentState;
    }

    synchronized Chart getGlobalPC() {
        return this.fGlobalPC;
    }

    public TmfPieChartStatisticsModel getModel() {
        return this.fModel;
    }

    synchronized Chart getTimeRangePC() {
        return this.fTimeRangePC;
    }

    private Map<String, Long> getTotalEventCountForChart(boolean isGlobal) {
        if (this.fModel == null) {
            return null;
        }
        Map<ITmfTrace, Map<String, Long>> chartModel = isGlobal ? this.fModel.getPieChartGlobalModel() : this.fModel.getPieChartSelectionModel();
        if (chartModel == null) {
            return null;
        }
        HashMap<String, Long> totalEventCountForChart = new HashMap<String, Long>();
        for (Map.Entry<ITmfTrace, Map<String, Long>> entry : chartModel.entrySet()) {
            Map<String, Long> traceEventCount = entry.getValue();
            if (traceEventCount == null) continue;
            for (Map.Entry<String, Long> event : traceEventCount.entrySet()) {
                Long value = (Long)totalEventCountForChart.get(event.getKey());
                if (value != null) {
                    totalEventCountForChart.put(event.getKey(), value + event.getValue());
                    continue;
                }
                totalEventCountForChart.put(event.getKey(), event.getValue());
            }
        }
        return totalEventCountForChart;
    }

    private synchronized void initContent() {
        this.setLayout((Layout)new FillLayout());
        this.fGlobalPC = null;
        this.fTimeRangePC = null;
        this.fMouseMoveListener = event -> {
            TmfPieChart pc = (TmfPieChart)event.widget;
            switch (event.type) {
                case 5: {
                    PieSlice slice = pc.getSliceFromPosition(event.x, event.y);
                    if (slice == null) {
                        pc.setToolTipText(null);
                        break;
                    }
                    long nbEvents = (long)slice.getValue();
                    float percOfSlice = (float)((double)nbEvents / pc.getTotal() * 100.0);
                    String percent = String.format("%.1f", Float.valueOf(percOfSlice));
                    String text = String.valueOf(Messages.TmfStatisticsView_PieChartToolTipTextName) + " = " + slice.getLabel() + "\n";
                    text = String.valueOf(text) + Messages.TmfStatisticsView_PieChartToolTipTextEventCount + " = " + nbEvents + " (" + percent + "%)";
                    pc.setToolTipText(text);
                    return;
                }
            }
        };
        this.fMouseClickListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TmfPieChart pc = (TmfPieChart)e.widget;
                PieSlice slice = pc.getSliceFromPosition(e.x, e.y);
                TmfPieChartViewer.this.fSelected = slice;
                if (slice == null) {
                    return;
                }
                String id = TmfPieChartViewer.this.fSelected.getID();
                TmfPieChartViewer.this.select(id);
                Event selectionEvent = new Event();
                selectionEvent.text = slice.getLabel();
                TmfPieChartViewer.this.notifyEventTypeSelectionListener(selectionEvent);
            }

            public void mouseUp(MouseEvent e) {
            }
        };
        this.setCurrentState(new PieChartViewerStateNoContentSelected(this));
    }

    private void notifyEventTypeSelectionListener(Event e) {
        Object[] objectArray = this.fEventTypeSelectedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((Listener)o).handleEvent(e);
            ++n2;
        }
    }

    public synchronized void refresh(boolean refreshGlobal, boolean refreshSelection) {
        if (this.fModel == null) {
            this.reinitializeCharts();
        } else {
            if (refreshGlobal) {
                this.getCurrentState().newGlobalEntries(this);
            }
            if (refreshSelection) {
                int nbEventsType = 0;
                Map<String, Long> selectionModel = this.getTotalEventCountForChart(false);
                for (Long l : selectionModel.values()) {
                    if (l == 0L) continue;
                    ++nbEventsType;
                }
                if (nbEventsType < 2) {
                    this.getCurrentState().newEmptySelection(this);
                } else {
                    this.getCurrentState().newSelection(this);
                }
            }
        }
    }

    public synchronized void reinitializeCharts() {
        if (this.isDisposed()) {
            return;
        }
        if (this.getGlobalPC() != null && !this.getGlobalPC().isDisposed()) {
            this.getGlobalPC().dispose();
        }
        this.fGlobalPC = new TmfPieChart(this, 0);
        this.getGlobalPC().getTitle().setText(this.fGlobalPCname);
        this.getGlobalPC().getAxisSet().getXAxis(0).getTitle().setText("");
        if (this.getTimeRangePC() != null && !this.getTimeRangePC().isDisposed()) {
            this.getTimeRangePC().dispose();
            this.fTimeRangePC = null;
        }
        this.layout();
        this.setCurrentState(new PieChartViewerStateNoContentSelected(this));
    }

    public void removeEventTypeSelectionListener(Listener l) {
        this.fEventTypeSelectedListeners.remove((Object)l);
    }

    public synchronized void setCurrentState(IPieChartViewerState newState) {
        this.fCurrentState = newState;
    }

    public void setInput(TmfPieChartStatisticsModel model) {
        this.fModel = model;
    }

    public synchronized void setTimeRangePC(TmfPieChart newChart) {
        this.fTimeRangePC = newChart;
    }

    synchronized void updateGlobalPieChart() {
        if (this.getGlobalPC() == null) {
            this.fGlobalPC = new TmfPieChart(this, 0);
            Color backgroundColor = this.fColorScheme.getColor(38);
            Color foregroundColor = this.fColorScheme.getColor(39);
            this.getGlobalPC().getTitle().setText(this.fGlobalPCname);
            this.getGlobalPC().getTitle().setForeground(foregroundColor);
            this.getGlobalPC().setBackground(backgroundColor);
            this.getGlobalPC().setForeground(foregroundColor);
            this.getGlobalPC().getAxisSet().getXAxis(0).getTitle().setText("");
            this.getGlobalPC().getAxisSet().getXAxis(0).getTitle().setForeground(foregroundColor);
            this.getGlobalPC().getLegend().setVisible(true);
            this.getGlobalPC().getLegend().setPosition(1024);
            this.getGlobalPC().getLegend().setBackground(backgroundColor);
            this.getGlobalPC().getLegend().setForeground(foregroundColor);
            this.getGlobalPC().addListener(5, this.fMouseMoveListener);
            this.getGlobalPC().addMouseListener(this.fMouseClickListener);
        } else if (this.getGlobalPC().isDisposed() || this.fModel == null || this.fModel.getPieChartGlobalModel() == null) {
            return;
        }
        Map<String, Long> totalEventCountForChart = this.getTotalEventCountForChart(true);
        if (totalEventCountForChart == null) {
            return;
        }
        TmfPieChartViewer.updatePieChartWithData(this.fGlobalPC, totalEventCountForChart, 0.025f, this.fOthersSliceName);
    }

    synchronized void updateTimeRangeSelectionPieChart() {
        if (this.getTimeRangePC() == null) {
            Color backgroundColor = this.fColorScheme.getColor(38);
            Color foregroundColor = this.fColorScheme.getColor(39);
            this.fTimeRangePC = new TmfPieChart(this, 0);
            this.fTimeRangePC.setBackground(backgroundColor);
            this.fTimeRangePC.setForeground(foregroundColor);
            this.getTimeRangePC().getTitle().setText(this.fTimeRangePCname);
            this.getTimeRangePC().getTitle().setForeground(foregroundColor);
            this.getTimeRangePC().getAxisSet().getXAxis(0).getTitle().setText("");
            this.getTimeRangePC().getAxisSet().getXAxis(0).getTitle().setForeground(foregroundColor);
            this.getTimeRangePC().getLegend().setPosition(1024);
            this.getTimeRangePC().getLegend().setVisible(true);
            this.getTimeRangePC().getLegend().setBackground(backgroundColor);
            this.getTimeRangePC().getLegend().setForeground(foregroundColor);
            this.getTimeRangePC().addListener(5, this.fMouseMoveListener);
            this.getTimeRangePC().addMouseListener(this.fMouseClickListener);
        } else if (this.getTimeRangePC().isDisposed()) {
            return;
        }
        Map<String, Long> totalEventCountForChart = this.getTotalEventCountForChart(false);
        if (totalEventCountForChart == null) {
            return;
        }
        TmfPieChartViewer.updatePieChartWithData(this.fTimeRangePC, totalEventCountForChart, 0.025f, this.fOthersSliceName);
    }

    public void select(String id) {
        if (id == null) {
            return;
        }
        TmfPieChart pieChart = this.fGlobalPC;
        if (pieChart != null) {
            pieChart.select(id);
            pieChart.redraw();
        }
        if ((pieChart = this.fTimeRangePC) != null) {
            pieChart.select(id);
            pieChart.redraw();
        }
    }

    private static class EventOccurrenceObject {
        private final String fId;
        private final String fName;
        private final Long fNbOccurrences;

        public EventOccurrenceObject(String name, Long nbOccurences, String id) {
            this.fName = name;
            this.fNbOccurrences = nbOccurences;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public Long getNbOccurence() {
            return this.fNbOccurrences;
        }
    }
}

