/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.filters;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;

public class TimeQueryFilter {
    private final long[] fTimesRequested;

    public TimeQueryFilter(long start, long end, int n) {
        this.fTimesRequested = TimeQueryFilter.splitRangeIntoEqualParts(start, end, n);
    }

    public TimeQueryFilter(List<Long> times) {
        if (!Ordering.natural().isOrdered(times)) {
            throw new IllegalArgumentException("List of times is not sorted");
        }
        this.fTimesRequested = Longs.toArray(times);
    }

    public long[] getTimesRequested() {
        return this.fTimesRequested;
    }

    public long getStart() {
        return this.fTimesRequested[0];
    }

    public long getEnd() {
        return this.fTimesRequested[Integer.max(0, this.fTimesRequested.length - 1)];
    }

    private static final long[] splitRangeIntoEqualParts(long start, long end, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of entries must be greater than 0");
        }
        if (n == 1) {
            if (start == end) {
                long[] result = new long[]{start};
                return result;
            }
            throw new IllegalArgumentException("Number of entries requested is 1, but start and end are different. Impossible to create array.");
        }
        if (n > 65536) {
            Activator.logWarning(String.format("Number of entries is very large, it is likely a bug and will result in slower queries. start time = %d, end time = %d, number of elements = %d", start, end, n));
        }
        double stepSize = (double)Math.abs(end - start) / ((double)n - 1.0);
        long[] result = new long[n];
        int i = 0;
        while (i < n) {
            result[i] = Math.min(start, end) + Math.round((double)i * stepSize);
            ++i;
        }
        result[result.length - 1] = Math.max(start, end);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TimeQueryFilter other = (TimeQueryFilter)obj;
        return Arrays.equals(this.fTimesRequested, other.getTimesRequested());
    }

    public int hashCode() {
        return Arrays.hashCode(this.fTimesRequested);
    }
}

