/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTConversionName
extends CPPASTNameBase
implements ICPPASTConversionName {
    private IASTTypeId typeId;
    private char[] fName;

    public CPPASTConversionName() {
    }

    public CPPASTConversionName(IASTTypeId typeId) {
        this.setTypeId(typeId);
    }

    @Override
    public CPPASTConversionName copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTConversionName copy(IASTNode.CopyStyle style) {
        CPPASTConversionName copy = new CPPASTConversionName();
        copy.setTypeId(this.typeId == null ? null : this.typeId.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    protected IBinding createIntermediateBinding() {
        return CPPVisitor.createBinding(this);
    }

    @Override
    public char[] toCharArray() {
        if (this.fName == null) {
            IType t = null;
            if (this.typeId != null) {
                t = CPPVisitor.createType(this.typeId);
            }
            this.fName = CPPASTConversionName.createName(t, this.typeId);
        }
        return this.fName;
    }

    public static char[] createName(String targetName) {
        StringBuilder buf = new StringBuilder();
        buf.append(Keywords.cOPERATOR);
        buf.append(' ');
        buf.append(targetName);
        int len = buf.length();
        char[] name = new char[len];
        buf.getChars(0, len, name, 0);
        return name;
    }

    public static char[] createName(IType t, IASTNode typeId) {
        StringBuilder buf = new StringBuilder();
        buf.append(Keywords.cOPERATOR);
        buf.append(' ');
        if (t != null) {
            ASTTypeUtil.appendType(t, true, buf);
        } else {
            buf.append(typeId.getRawSignature());
            WHITESPACE_SEQ.matcher(buf).replaceAll(" ");
        }
        int len = buf.length();
        char[] name = new char[len];
        buf.getChars(0, len, name, 0);
        return name;
    }

    @Override
    public char[] getSimpleID() {
        return this.toCharArray();
    }

    @Override
    public char[] getLookupKey() {
        return Keywords.cOPERATOR;
    }
}

