/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;

public class SubMenuManager
extends SubContributionManager
implements IMenuManager {
    private Map<IMenuManager, SubMenuManager> mapMenuToWrapper;
    private ListenerList<IMenuListener> menuListeners = new ListenerList();
    private IMenuListener menuListener;

    public SubMenuManager(IMenuManager mgr) {
        super(mgr);
    }

    @Override
    public void addMenuListener(IMenuListener listener) {
        this.menuListeners.add((Object)listener);
        if (this.menuListener == null) {
            this.menuListener = manager -> {
                for (IMenuListener localListener : this.menuListeners) {
                    localListener.menuAboutToShow(this);
                }
            };
        }
        this.getParentMenuManager().addMenuListener(this.menuListener);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void disposeManager() {
        if (this.menuListener != null) {
            this.getParentMenuManager().removeMenuListener(this.menuListener);
            this.menuListener = null;
            this.menuListeners.clear();
        }
        if (this.mapMenuToWrapper != null) {
            for (SubMenuManager wrapper : this.mapMenuToWrapper.values()) {
                wrapper.disposeManager();
            }
            this.mapMenuToWrapper.clear();
            this.mapMenuToWrapper = null;
        }
        super.disposeManager();
    }

    @Override
    public void fill(Composite parent) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(parent);
        }
    }

    @Override
    public void fill(CoolBar parent, int index) {
    }

    @Override
    public void fill(Menu parent, int index) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(parent, index);
        }
    }

    @Override
    public void fill(ToolBar parent, int index) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(parent, index);
        }
    }

    @Override
    public IContributionItem find(String id) {
        IContributionItem item = this.getParentMenuManager().find(id);
        if (item instanceof SubContributionItem) {
            item = this.unwrap(item);
        }
        if (item instanceof IMenuManager) {
            IMenuManager menu = (IMenuManager)item;
            item = this.getWrapper(menu);
        }
        return item;
    }

    @Override
    public IMenuManager findMenuUsingPath(String path) {
        IContributionItem item = this.findUsingPath(path);
        if (item instanceof IMenuManager) {
            return (IMenuManager)item;
        }
        return null;
    }

    @Override
    public IContributionItem findUsingPath(String path) {
        String id = path;
        String rest = null;
        int separator = path.indexOf(47);
        if (separator != -1) {
            id = path.substring(0, separator);
            rest = path.substring(separator + 1);
        }
        IContributionItem item = this.find(id);
        if (rest != null && item instanceof IMenuManager) {
            IMenuManager menu = (IMenuManager)item;
            item = menu.findUsingPath(rest);
        }
        return item;
    }

    @Override
    public String getId() {
        return this.getParentMenuManager().getId();
    }

    protected final IMenuManager getParentMenuManager() {
        return (IMenuManager)this.getParent();
    }

    @Override
    public boolean getRemoveAllWhenShown() {
        return false;
    }

    protected IMenuManager getWrapper(IMenuManager mgr) {
        SubMenuManager wrapper;
        if (this.mapMenuToWrapper == null) {
            this.mapMenuToWrapper = new HashMap<IMenuManager, SubMenuManager>(4);
        }
        if ((wrapper = this.mapMenuToWrapper.get(mgr)) == null) {
            wrapper = this.wrapMenu(mgr);
            this.mapMenuToWrapper.put(mgr, wrapper);
        }
        return wrapper;
    }

    @Override
    public boolean isDynamic() {
        return this.getParentMenuManager().isDynamic();
    }

    @Override
    public boolean isEnabled() {
        return this.isVisible() && this.getParentMenuManager().isEnabled();
    }

    @Override
    public boolean isGroupMarker() {
        return this.getParentMenuManager().isGroupMarker();
    }

    @Override
    public boolean isSeparator() {
        return this.getParentMenuManager().isSeparator();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (this.mapMenuToWrapper != null) {
            for (SubMenuManager wrapper : this.mapMenuToWrapper.values()) {
                wrapper.removeAll();
            }
            this.mapMenuToWrapper.clear();
            this.mapMenuToWrapper = null;
        }
    }

    @Override
    public void removeMenuListener(IMenuListener listener) {
        this.menuListeners.remove((Object)listener);
    }

    @Override
    public void saveWidgetState() {
    }

    @Override
    public void setParent(IContributionManager parent) {
    }

    @Override
    public void setRemoveAllWhenShown(boolean removeAll) {
        Assert.isTrue((boolean)false, (String)"Should not be called on submenu manager");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mapMenuToWrapper != null) {
            for (SubMenuManager wrapper : this.mapMenuToWrapper.values()) {
                wrapper.setVisible(visible);
            }
        }
    }

    @Override
    public void update() {
        this.getParentMenuManager().update();
    }

    @Override
    public void update(boolean force) {
        this.getParentMenuManager().update(force);
    }

    @Override
    public void update(String id) {
        this.getParentMenuManager().update(id);
    }

    @Override
    public void updateAll(boolean force) {
        this.getParentMenuManager().updateAll(force);
    }

    protected SubMenuManager wrapMenu(IMenuManager menu) {
        SubMenuManager mgr = new SubMenuManager(menu);
        mgr.setVisible(this.isVisible());
        return mgr;
    }
}

