/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;

@NonNullByDefault
public final class ByteArrayDefinition
extends AbstractArrayDefinition {
    private final byte[] fContent;
    private transient @Nullable List<Definition> fDefs;

    public ByteArrayDefinition(CompoundDeclaration declaration, @Nullable IDefinitionScope definitionScope, String fieldName, byte[] content) {
        super(declaration, definitionScope, fieldName);
        this.fContent = content;
    }

    @Override
    public int getLength() {
        return this.fContent.length;
    }

    @Override
    public synchronized List<Definition> getDefinitions() {
        List<Definition> defs = this.fDefs;
        if (defs == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            int i = 0;
            while (i < this.fContent.length) {
                IntegerDeclaration charDecl = IntegerDeclaration.UINT_8_DECL;
                String fieldName = String.valueOf(this.getFieldName()) + '[' + i + ']';
                byte fieldValue = this.fContent[i];
                builder.add((Object)new IntegerDefinition(charDecl, this.getDefinitionScope(), fieldName, fieldValue));
                ++i;
            }
            this.fDefs = builder.build();
            return this.fDefs;
        }
        return defs;
    }

    @Override
    public String toString() {
        if (((CompoundDeclaration)this.getDeclaration()).isString()) {
            int pos = -1;
            int i = 0;
            while (i < this.fContent.length) {
                if (this.fContent[i] == 0) {
                    pos = i;
                    break;
                }
                ++i;
            }
            byte[] bytes = pos != -1 ? Arrays.copyOf(this.fContent, pos) : this.fContent;
            return new String(bytes);
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        Joiner.on((String)", ").appendTo(b, Arrays.asList(new byte[][]{this.fContent}));
        b.append(']');
        return b.toString();
    }

    public byte getByte(int index) {
        return this.fContent[index];
    }
}

