/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.graph;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.TmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphOps;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.junit.Assert;
import org.junit.Test;

public class DistributedCriticalPathTest {
    private static final String EXPERIMENT = "CritPathExperiment";
    private static int BLOCK_SIZE = 1000;
    private static final @NonNull String TEST_ANALYSIS_ID = "org.eclipse.tracecompass.analysis.os.linux.execgraph";

    private ITmfTrace setUpExperiment(String ... traceFiles) throws TmfTraceException {
        ITmfTrace[] traces = new ITmfTrace[traceFiles.length];
        int i = 0;
        Object object = traceFiles;
        int n = traceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
            String traceFile = object[n2];
            IPath filePath = Activator.getAbsoluteFilePath(traceFile);
            IStatus status = trace.validate(null, filePath.toOSString());
            if (!status.isOK()) {
                Assert.fail((String)status.getException().getMessage());
            }
            trace.initTrace(null, filePath.toOSString(), ITmfEvent.class);
            traces[i++] = trace;
            ++n2;
        }
        TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, EXPERIMENT, traces, BLOCK_SIZE, null);
        experiment.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null));
        IAnalysisModule module = null;
        object = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)experiment, TmfGraphBuilderModule.class).iterator();
        while (object.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)object.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        return experiment;
    }

    @Test
    public void testNetworkExchangeWithWifi() throws TmfTraceException, TmfAnalysisException {
        ITmfTrace experiment = this.setUpExperiment("testfiles/graph/network_exchange_eth.xml", "testfiles/graph/network_exchange_wifi.xml");
        Assert.assertNotNull((Object)experiment);
        try {
            DistributedCriticalPathTest.internalTestNetworkExchangeWithWifi(experiment);
        }
        finally {
            experiment.dispose();
        }
    }

    private static void internalTestNetworkExchangeWithWifi(@NonNull ITmfTrace experiment) throws TmfAnalysisException {
        TmfGraphBuilderModule module = (TmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, TmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        TmfGraph graph = module.getGraph();
        Assert.assertNotNull((Object)graph);
        Set workers = graph.getWorkers();
        Assert.assertEquals((long)6L, (long)workers.size());
        HashMap<Integer, IGraphWorker> workerMap = new HashMap<Integer, IGraphWorker>();
        for (IGraphWorker worker : workers) {
            workerMap.put(((OsWorker)worker).getHostThread().getTid(), worker);
        }
        TmfGraph expected = new TmfGraph();
        IGraphWorker worker = (IGraphWorker)workerMap.get(201);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(10L));
        expected.append(worker, new TmfVertex(15L), TmfEdge.EdgeType.PREEMPTED);
        expected.append(worker, new TmfVertex(60L), TmfEdge.EdgeType.RUNNING);
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(10L));
        TmfVertex packet1Sent = new TmfVertex(13L);
        expected.append(worker, packet1Sent, TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(15L), TmfEdge.EdgeType.RUNNING);
        TmfVertex packet2Received = new TmfVertex(70L);
        expected.append(worker, packet2Received, TmfEdge.EdgeType.NETWORK, "irq/30-handler");
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.PREEMPTED);
        worker = (IGraphWorker)workerMap.get(50);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(55L));
        expected.append(worker, new TmfVertex(60L), TmfEdge.EdgeType.PREEMPTED);
        expected.append(worker, new TmfVertex(65L), TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.RUNNING);
        worker = (IGraphWorker)workerMap.get(101);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(5L));
        expected.append(worker, new TmfVertex(40L), TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(55L), TmfEdge.EdgeType.PREEMPTED);
        worker = (IGraphWorker)workerMap.get(100);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(5L));
        TmfVertex packet1Received = new TmfVertex(35L);
        expected.append(worker, packet1Received, TmfEdge.EdgeType.NETWORK);
        expected.append(worker, new TmfVertex(40L), TmfEdge.EdgeType.PREEMPTED);
        TmfVertex packet2Sent = new TmfVertex(45L);
        expected.append(worker, packet2Sent, TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(55L), TmfEdge.EdgeType.RUNNING);
        TmfEdge link = packet1Sent.linkVertical(packet1Received);
        link.setType(TmfEdge.EdgeType.NETWORK);
        link = packet2Sent.linkVertical(packet2Received);
        link.setType(TmfEdge.EdgeType.NETWORK);
        worker = (IGraphWorker)workerMap.get(-1);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(30L));
        expected.append(worker, new TmfVertex(33L), TmfEdge.EdgeType.RUNNING);
        GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)graph);
        expected = new TmfGraph();
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(10L));
        expected.append(worker, new TmfVertex(13L), TmfEdge.EdgeType.RUNNING);
        packet1Sent = new TmfVertex(15L);
        expected.append(worker, packet1Sent, TmfEdge.EdgeType.RUNNING);
        packet2Received = new TmfVertex(70L);
        expected.add(worker, packet2Received);
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.PREEMPTED);
        worker = (IGraphWorker)workerMap.get(100);
        Assert.assertNotNull((Object)worker);
        packet1Received = new TmfVertex(35L);
        expected.add(worker, packet1Received);
        expected.append(worker, new TmfVertex(40L), TmfEdge.EdgeType.PREEMPTED);
        packet2Sent = new TmfVertex(45L);
        expected.append(worker, packet2Sent, TmfEdge.EdgeType.RUNNING);
        link = packet1Sent.linkVertical(packet1Received);
        link.setType(TmfEdge.EdgeType.NETWORK);
        link = packet2Sent.linkVertical(packet2Received);
        link.setType(TmfEdge.EdgeType.NETWORK);
        CriticalPathModule critPathModule = new CriticalPathModule(module);
        try {
            critPathModule.setTrace(experiment);
            critPathModule.setParameter("workerid", workerMap.get(200));
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            TmfGraph criticalPath = critPathModule.getCriticalPath();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)criticalPath);
        }
        finally {
            critPathModule.dispose();
        }
    }

    @Test
    public void testNetworkExchange() throws TmfTraceException, TmfAnalysisException {
        ITmfTrace experiment = this.setUpExperiment("testfiles/graph/simple_network_server.xml", "testfiles/graph/simple_network_client.xml");
        Assert.assertNotNull((Object)experiment);
        try {
            DistributedCriticalPathTest.internalTestNetworkExchange(experiment);
        }
        finally {
            experiment.dispose();
        }
    }

    private static void internalTestNetworkExchange(@NonNull ITmfTrace experiment) throws TmfAnalysisException {
        TmfGraphBuilderModule module = (TmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, TmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        TmfGraph graph = module.getGraph();
        Assert.assertNotNull((Object)graph);
        Set workers = graph.getWorkers();
        Assert.assertEquals((long)7L, (long)workers.size());
        OsWorker clientWorker = null;
        OsWorker serverWorker = null;
        HashMap<Integer, IGraphWorker> workerMap = new HashMap<Integer, IGraphWorker>();
        for (IGraphWorker worker : workers) {
            OsWorker osWorker = (OsWorker)worker;
            if (osWorker.getHostThread().getTid() < 0) {
                if (osWorker.getHostId().equals("simple_network_server.xml")) {
                    serverWorker = osWorker;
                } else {
                    clientWorker = osWorker;
                }
            }
            workerMap.put(osWorker.getHostThread().getTid(), worker);
        }
        TmfGraph expected = new TmfGraph();
        IGraphWorker worker = (IGraphWorker)workerMap.get(201);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(7L));
        expected.append(worker, new TmfVertex(10L), TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(15L), TmfEdge.EdgeType.PREEMPTED);
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.RUNNING);
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(10L));
        TmfVertex packet1Sent = new TmfVertex(13L);
        expected.append(worker, packet1Sent, TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(15L), TmfEdge.EdgeType.RUNNING);
        TmfVertex packet2Received = new TmfVertex(70L);
        expected.append(worker, packet2Received, TmfEdge.EdgeType.NETWORK);
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.PREEMPTED);
        TmfVertex wakeupSource = new TmfVertex(90L);
        expected.append(worker, wakeupSource, TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(95L), TmfEdge.EdgeType.RUNNING);
        worker = clientWorker;
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(60L));
        expected.append(worker, new TmfVertex(65L), TmfEdge.EdgeType.RUNNING);
        worker = (IGraphWorker)workerMap.get(202);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(7L));
        TmfVertex wakeupTarget = new TmfVertex(90L);
        expected.append(worker, wakeupTarget, TmfEdge.EdgeType.BLOCKED);
        expected.append(worker, new TmfVertex(95L), TmfEdge.EdgeType.PREEMPTED);
        wakeupSource.linkVertical(wakeupTarget);
        worker = (IGraphWorker)workerMap.get(101);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(5L));
        expected.append(worker, new TmfVertex(40L), TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(55L), TmfEdge.EdgeType.PREEMPTED);
        worker = (IGraphWorker)workerMap.get(100);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(5L));
        TmfVertex packet1Received = new TmfVertex(35L);
        expected.append(worker, packet1Received, TmfEdge.EdgeType.NETWORK);
        expected.append(worker, new TmfVertex(40L), TmfEdge.EdgeType.PREEMPTED);
        TmfVertex packet2Sent = new TmfVertex(45L);
        expected.append(worker, packet2Sent, TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(55L), TmfEdge.EdgeType.RUNNING);
        TmfEdge link = packet1Sent.linkVertical(packet1Received);
        link.setType(TmfEdge.EdgeType.NETWORK);
        link = packet2Sent.linkVertical(packet2Received);
        link.setType(TmfEdge.EdgeType.NETWORK);
        worker = serverWorker;
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(30L));
        expected.append(worker, new TmfVertex(33L), TmfEdge.EdgeType.RUNNING);
        GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)graph);
        expected = new TmfGraph();
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(10L));
        expected.append(worker, new TmfVertex(13L), TmfEdge.EdgeType.RUNNING);
        packet1Sent = new TmfVertex(15L);
        expected.append(worker, packet1Sent, TmfEdge.EdgeType.RUNNING);
        packet2Received = new TmfVertex(70L);
        expected.add(worker, packet2Received);
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.PREEMPTED);
        expected.append(worker, new TmfVertex(90L), TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(95L), TmfEdge.EdgeType.RUNNING);
        worker = (IGraphWorker)workerMap.get(100);
        Assert.assertNotNull((Object)worker);
        packet1Received = new TmfVertex(35L);
        expected.add(worker, packet1Received);
        expected.append(worker, new TmfVertex(40L), TmfEdge.EdgeType.PREEMPTED);
        packet2Sent = new TmfVertex(45L);
        expected.append(worker, packet2Sent, TmfEdge.EdgeType.RUNNING);
        link = packet1Sent.linkVertical(packet1Received);
        link.setType(TmfEdge.EdgeType.NETWORK);
        link = packet2Sent.linkVertical(packet2Received);
        link.setType(TmfEdge.EdgeType.NETWORK);
        CriticalPathModule critPathModule = new CriticalPathModule(module);
        try {
            critPathModule.setTrace(experiment);
            critPathModule.setParameter("workerid", workerMap.get(200));
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            TmfGraph criticalPath = critPathModule.getCriticalPath();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)criticalPath);
        }
        finally {
            critPathModule.dispose();
        }
    }

    @Test
    public void testNetworkExchangeOneTrace() throws TmfTraceException, TmfAnalysisException {
        ITmfTrace experiment = this.setUpExperiment("testfiles/graph/network_exchange_wifi.xml");
        Assert.assertNotNull((Object)experiment);
        try {
            DistributedCriticalPathTest.internalTestNetworkExchangeOneTrace(experiment);
        }
        finally {
            experiment.dispose();
        }
    }

    private static void internalTestNetworkExchangeOneTrace(@NonNull ITmfTrace experiment) throws TmfAnalysisException {
        TmfGraphBuilderModule module = (TmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, TmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        TmfGraph graph = module.getGraph();
        Assert.assertNotNull((Object)graph);
        Set workers = graph.getWorkers();
        Assert.assertEquals((long)3L, (long)workers.size());
        HashMap<Integer, IGraphWorker> workerMap = new HashMap<Integer, IGraphWorker>();
        for (IGraphWorker worker : workers) {
            workerMap.put(((OsWorker)worker).getHostThread().getTid(), worker);
        }
        TmfGraph expected = new TmfGraph();
        IGraphWorker worker = (IGraphWorker)workerMap.get(201);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(10L));
        expected.append(worker, new TmfVertex(15L), TmfEdge.EdgeType.PREEMPTED);
        expected.append(worker, new TmfVertex(60L), TmfEdge.EdgeType.RUNNING);
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(10L));
        TmfVertex packet1Sent = new TmfVertex(13L);
        expected.append(worker, packet1Sent, TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(15L), TmfEdge.EdgeType.RUNNING);
        TmfVertex packet2Received = new TmfVertex(70L);
        expected.append(worker, packet2Received, TmfEdge.EdgeType.NETWORK, "irq/30-handler");
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.PREEMPTED);
        worker = (IGraphWorker)workerMap.get(50);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(55L));
        expected.append(worker, new TmfVertex(60L), TmfEdge.EdgeType.PREEMPTED);
        expected.append(worker, new TmfVertex(65L), TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.RUNNING);
        GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)graph);
        expected = new TmfGraph();
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        for (TmfVertex vertex : graph.getNodesOf(worker)) {
            expected.add(worker, vertex);
        }
        CriticalPathModule critPathModule = new CriticalPathModule(module);
        try {
            critPathModule.setTrace(experiment);
            critPathModule.setParameter("workerid", workerMap.get(200));
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            TmfGraph criticalPath = critPathModule.getCriticalPath();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)criticalPath);
        }
        finally {
            critPathModule.dispose();
        }
    }

    @Test
    public void testNetworkExchangeOneTraceSoftirq() throws TmfTraceException, TmfAnalysisException {
        ITmfTrace experiment = this.setUpExperiment("testfiles/graph/simple_network_client.xml");
        Assert.assertNotNull((Object)experiment);
        try {
            DistributedCriticalPathTest.internalTestNetworkExchangeOneTraceSoftirq(experiment);
        }
        finally {
            experiment.dispose();
        }
    }

    private static void internalTestNetworkExchangeOneTraceSoftirq(@NonNull ITmfTrace experiment) throws TmfAnalysisException {
        TmfGraphBuilderModule module = (TmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, TmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        TmfGraph graph = module.getGraph();
        Assert.assertNotNull((Object)graph);
        Set workers = graph.getWorkers();
        Assert.assertEquals((long)4L, (long)workers.size());
        OsWorker clientWorker = null;
        HashMap<Integer, IGraphWorker> workerMap = new HashMap<Integer, IGraphWorker>();
        for (IGraphWorker worker : workers) {
            OsWorker osWorker = (OsWorker)worker;
            if (osWorker.getHostThread().getTid() < 0) {
                clientWorker = osWorker;
            }
            workerMap.put(osWorker.getHostThread().getTid(), worker);
        }
        TmfGraph expected = new TmfGraph();
        IGraphWorker worker = (IGraphWorker)workerMap.get(201);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(7L));
        expected.append(worker, new TmfVertex(10L), TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(15L), TmfEdge.EdgeType.PREEMPTED);
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.RUNNING);
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(10L));
        TmfVertex packet1Sent = new TmfVertex(13L);
        expected.append(worker, packet1Sent, TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(15L), TmfEdge.EdgeType.RUNNING);
        TmfVertex packet2Received = new TmfVertex(70L);
        expected.append(worker, packet2Received, TmfEdge.EdgeType.NETWORK);
        expected.append(worker, new TmfVertex(75L), TmfEdge.EdgeType.PREEMPTED);
        TmfVertex wakeupSource = new TmfVertex(90L);
        expected.append(worker, wakeupSource, TmfEdge.EdgeType.RUNNING);
        expected.append(worker, new TmfVertex(95L), TmfEdge.EdgeType.RUNNING);
        worker = clientWorker;
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(60L));
        expected.append(worker, new TmfVertex(65L), TmfEdge.EdgeType.RUNNING);
        worker = (IGraphWorker)workerMap.get(202);
        Assert.assertNotNull((Object)worker);
        expected.add(worker, new TmfVertex(7L));
        TmfVertex wakeupTarget = new TmfVertex(90L);
        expected.append(worker, wakeupTarget, TmfEdge.EdgeType.BLOCKED);
        expected.append(worker, new TmfVertex(95L), TmfEdge.EdgeType.PREEMPTED);
        wakeupSource.linkVertical(wakeupTarget);
        GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)graph);
        expected = new TmfGraph();
        IGraphWorker cWorker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)cWorker);
        expected.add(cWorker, new TmfVertex(10L));
        expected.append(cWorker, new TmfVertex(13L), TmfEdge.EdgeType.RUNNING);
        packet1Sent = new TmfVertex(15L);
        expected.append(cWorker, packet1Sent, TmfEdge.EdgeType.RUNNING);
        packet2Received = new TmfVertex(70L);
        expected.append(cWorker, packet2Received, TmfEdge.EdgeType.NETWORK);
        expected.append(cWorker, new TmfVertex(75L), TmfEdge.EdgeType.PREEMPTED);
        wakeupSource = new TmfVertex(90L);
        expected.append(cWorker, wakeupSource, TmfEdge.EdgeType.RUNNING);
        expected.append(cWorker, new TmfVertex(95L), TmfEdge.EdgeType.RUNNING);
        CriticalPathModule critPathModule = new CriticalPathModule(module);
        try {
            critPathModule.setTrace(experiment);
            critPathModule.setParameter("workerid", (Object)cWorker);
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            TmfGraph criticalPath = critPathModule.getCriticalPath();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)criticalPath);
            expected = new TmfGraph();
            worker = (IGraphWorker)workerMap.get(202);
            Assert.assertNotNull((Object)worker);
            TmfVertex begin = new TmfVertex(7L);
            expected.add(worker, begin);
            wakeupTarget = new TmfVertex(90L);
            expected.add(worker, wakeupTarget);
            expected.append(worker, new TmfVertex(95L), TmfEdge.EdgeType.PREEMPTED);
            TmfVertex start = new TmfVertex(7L);
            expected.add(cWorker, start);
            expected.append(cWorker, new TmfVertex(10L), TmfEdge.EdgeType.UNKNOWN);
            expected.append(cWorker, new TmfVertex(13L), TmfEdge.EdgeType.RUNNING);
            packet1Sent = new TmfVertex(15L);
            expected.append(cWorker, packet1Sent, TmfEdge.EdgeType.RUNNING);
            packet2Received = new TmfVertex(70L);
            expected.append(cWorker, packet2Received, TmfEdge.EdgeType.NETWORK);
            expected.append(cWorker, new TmfVertex(75L), TmfEdge.EdgeType.PREEMPTED);
            wakeupSource = new TmfVertex(90L);
            expected.append(cWorker, wakeupSource, TmfEdge.EdgeType.RUNNING);
            begin.linkVertical(start);
            wakeupSource.linkVertical(wakeupTarget);
            critPathModule.setParameter("workerid", (Object)worker);
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            criticalPath = critPathModule.getCriticalPath();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((TmfGraph)expected, (TmfGraph)criticalPath);
        }
        finally {
            critPathModule.dispose();
        }
    }
}

