/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;

public class ChangesSection
extends Composite {
    private AbstractSynchronizePage page;
    private ISynchronizePageConfiguration configuration;
    private FormToolkit forms;
    private PageBook changesSectionContainer;
    private Viewer changesViewer;

    public ChangesSection(Composite parent, AbstractSynchronizePage page, ISynchronizePageConfiguration configuration) {
        super(parent, 0);
        this.page = page;
        this.configuration = configuration;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.setLayoutData(data);
        this.forms = new FormToolkit(parent.getDisplay());
        this.forms.setBackground(this.getListBackgroundColor());
        HyperlinkGroup group = this.forms.getHyperlinkGroup();
        group.setBackground(this.getListBackgroundColor());
        this.changesSectionContainer = new PageBook((Composite)this, 0);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.changesSectionContainer.setLayoutData((Object)data);
    }

    protected Color getListBackgroundColor() {
        return this.getShell().getDisplay().getSystemColor(25);
    }

    public PageBook getContainer() {
        return this.changesSectionContainer;
    }

    protected ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected FormToolkit getForms() {
        return this.forms;
    }

    protected AbstractSynchronizePage getPage() {
        return this.page;
    }

    public void dispose() {
        super.dispose();
        this.forms.dispose();
    }

    public void setViewer(Viewer viewer) {
        this.changesViewer = viewer;
        this.initializeChangesViewer();
    }

    protected void initializeChangesViewer() {
        TeamUIPlugin.getStandardDisplay().asyncExec(() -> {
            Control control = this.getChangesViewer().getControl();
            if (!this.getContainer().isDisposed() && !control.isDisposed()) {
                this.getContainer().showPage(control);
            }
        });
    }

    public Viewer getChangesViewer() {
        return this.changesViewer;
    }

    protected boolean isThreeWay() {
        return "three-way".equals(this.getConfiguration().getComparisonType());
    }
}

