/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.PrintWriter;
import org.eclipse.e4.core.services.about.AboutSections;
import org.eclipse.e4.core.services.about.ISystemInformation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ConfigurationLogDefaultSection
implements ISystemSummarySection {
    @Override
    public void write(PrintWriter writer) {
        BundleContext context = FrameworkUtil.getBundle(ISystemSummarySection.class).getBundleContext();
        this.appendSection("section.system.properties", WorkbenchMessages.SystemSummary_systemProperties, writer, context);
        this.appendSection("section.system.environment", WorkbenchMessages.SystemSummary_systemVariables, writer, context);
        this.appendSection("section.installed.features", WorkbenchMessages.SystemSummary_features, writer, context);
        this.appendSection("section.installed.bundles", WorkbenchMessages.SystemSummary_pluginRegistry, writer, context);
        this.appendSection("section.user.preferences", WorkbenchMessages.SystemSummary_userPreferences, writer, context);
    }

    private void appendSection(String section, String caption, PrintWriter writer, BundleContext context) {
        block8: {
            writer.println();
            writer.println(caption);
            ServiceReference reference = null;
            try {
                try {
                    reference = (ServiceReference)context.getServiceReferences(ISystemInformation.class, AboutSections.createSectionFilter((String)section)).stream().findFirst().get();
                    ISystemInformation service = (ISystemInformation)context.getService(reference);
                    service.append(writer);
                }
                catch (Exception e) {
                    WorkbenchPlugin.log(NLS.bind((String)"Failed to retrieve data for section: {0}", (Object)section), e);
                    writer.println(WorkbenchMessages.SystemSummary_sectionError);
                    if (reference != null) {
                        context.ungetService(reference);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (reference != null) {
                    context.ungetService(reference);
                }
                throw throwable;
            }
            if (reference != null) {
                context.ungetService(reference);
            }
        }
    }
}

