/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntryModel;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenXYDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DataDrivenOutputEntry
implements IDataDrivenRuntimeObject {
    private static final String SPLIT_STRING = "/";
    private static final Map<ITmfStateSystem, DataContainer> SS_TO_CONTAINER = new WeakHashMap<ITmfStateSystem, DataContainer>();
    private final List<DataDrivenOutputEntry> fChildrenEntries;
    private final String fPath;
    private final @Nullable String fAnalysisId;
    private final boolean fDisplayText;
    private final @Nullable DataDrivenStateSystemPath fDisplay;
    private final @Nullable DataDrivenStateSystemPath fId;
    private final @Nullable DataDrivenStateSystemPath fParent;
    private final @Nullable DataDrivenStateSystemPath fName;
    private final DataDrivenXYDataProvider.DisplayType fDisplayType;

    public DataDrivenOutputEntry(List<DataDrivenOutputEntry> entries, String path, @Nullable String analysisId, boolean displayText, @Nullable DataDrivenStateSystemPath display, @Nullable DataDrivenStateSystemPath id, @Nullable DataDrivenStateSystemPath parent, @Nullable DataDrivenStateSystemPath name, DataDrivenXYDataProvider.DisplayType displayType) {
        this.fChildrenEntries = entries;
        this.fPath = path;
        this.fAnalysisId = analysisId;
        this.fDisplayText = displayText;
        this.fDisplay = display;
        this.fId = id;
        this.fParent = parent;
        this.fName = name;
        this.fDisplayType = displayType;
    }

    public List<TimeGraphEntryModel> buildEntries(ITmfStateSystem ssq, long parentEntryId, ITmfTrace trace, int prevBaseQuark, String prevRegex, long currentEnd, IdGetter idGenerator, QuarkCallback callback) {
        ITmfStateSystem parentSs;
        String specificSs = this.fAnalysisId;
        ITmfStateSystem ss = parentSs = ssq;
        int baseQuark = prevBaseQuark;
        if (specificSs != null) {
            ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)specificSs);
            baseQuark = -1;
            if (ss == null) {
                return Collections.emptyList();
            }
        }
        DataContainer container = SS_TO_CONTAINER.computeIfAbsent(ss, s -> new DataContainer((ITmfStateSystem)s));
        Pattern pattern = Pattern.compile(prevRegex);
        String attributePath = prevBaseQuark > 0 ? parentSs.getFullAttributePath(prevBaseQuark) : "";
        Matcher matcher = pattern.matcher(attributePath);
        String path = this.fPath;
        if (matcher.find()) {
            path = matcher.replaceFirst(path);
        }
        String regexName = path.replaceAll("\\*", "(.*)");
        String[] paths = regexName.split(SPLIT_STRING);
        int i = 0;
        List<Integer> quarks = Collections.singletonList(baseQuark);
        while (i < paths.length) {
            ArrayList<Integer> subQuarks = new ArrayList<Integer>();
            String name = paths[i];
            for (int relativeQuark : quarks) {
                subQuarks.addAll(ss.getSubAttributes(relativeQuark, false, name));
            }
            quarks = subQuarks;
            ++i;
        }
        DataDrivenStateSystemPath displayPath = this.fDisplay;
        DataDrivenStateSystemPath namePath = this.fName;
        DataDrivenStateSystemPath idPath = this.fId;
        DataDrivenStateSystemPath parentPath = this.fParent;
        HashMap<String, DataDrivenOutputEntryModel.EntryBuilder> entryMap = new HashMap<String, DataDrivenOutputEntryModel.EntryBuilder>();
        ArrayList<DataDrivenOutputEntryModel.EntryBuilder> entries = new ArrayList<DataDrivenOutputEntryModel.EntryBuilder>();
        ArrayList<TimeGraphEntryModel> entryList = new ArrayList<TimeGraphEntryModel>();
        for (int quark : quarks) {
            long id = idGenerator.getIdFor(ss, quark);
            int displayQuark = -2;
            long entryStart = ss.getStartTime();
            long entryEnd = currentEnd;
            if (displayPath != null) {
                displayQuark = displayPath.getQuark(quark, container);
                if (displayQuark == -2) continue;
                callback.registerQuark(id, ss, displayQuark, this.fDisplayType);
                try {
                    long ts;
                    ITmfStateInterval oneInterval = ss.querySingleState(entryStart, displayQuark);
                    while (oneInterval.getStateValue().isNull()) {
                        ts = oneInterval.getEndTime() + 1L;
                        if (ts > currentEnd) break;
                        oneInterval = ss.querySingleState(ts, displayQuark);
                    }
                    entryStart = oneInterval.getStartTime();
                    oneInterval = ss.querySingleState(entryEnd - 1L, displayQuark);
                    while (oneInterval.getStateValue().isNull()) {
                        ts = oneInterval.getStartTime() - 1L;
                        if (ts < ss.getStartTime()) break;
                        oneInterval = ss.querySingleState(ts, displayQuark);
                    }
                    entryEnd = Math.min(oneInterval.getEndTime() + 1L, currentEnd);
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {}
            }
            String name = "";
            if (namePath != null) {
                name = DataDrivenOutputEntry.getFirstValue(quark, namePath, container);
            }
            if (name.isEmpty()) {
                name = ss.getAttributeName(quark);
            }
            String xmlId = idPath != null ? DataDrivenOutputEntry.getFirstValue(quark, idPath, container) : name;
            String xmlParentId = "";
            if (parentPath != null) {
                xmlParentId = DataDrivenOutputEntry.getFirstValue(quark, parentPath, container);
            }
            DataDrivenOutputEntryModel.EntryBuilder entryBuilder = new DataDrivenOutputEntryModel.EntryBuilder(id, parentEntryId, displayQuark, name, xmlId, xmlParentId, entryStart, entryEnd, this.fDisplayText, this.fDisplayType);
            entryMap.put(xmlId, entryBuilder);
            entries.add(entryBuilder);
            for (DataDrivenOutputEntry subEntry : this.fChildrenEntries) {
                @NonNull String regex = prevRegex.isEmpty() ? regexName : String.valueOf(prevRegex) + '/' + regexName;
                entryList.addAll(subEntry.buildEntries(ss, entryBuilder.getId(), trace, quark, regex, currentEnd, idGenerator, callback));
            }
        }
        DataDrivenOutputEntry.buildTree(entryMap);
        for (DataDrivenOutputEntryModel.EntryBuilder b : entries) {
            entryList.add(b.build());
        }
        return entryList;
    }

    private static void buildTree(Map<String, DataDrivenOutputEntryModel.EntryBuilder> entryMap) {
        for (DataDrivenOutputEntryModel.EntryBuilder entry : entryMap.values()) {
            DataDrivenOutputEntryModel.EntryBuilder parent;
            if (entry.getXmlParentId().isEmpty() || (parent = entryMap.get(entry.getXmlParentId())) == null || entry.getStartTime() > parent.getEndTime() || entry.getEndTime() < parent.getStartTime()) continue;
            entry.setParentId(parent.getId());
        }
    }

    private static String getFirstValue(int baseQuark, DataDrivenStateSystemPath path, DataContainer container) {
        int quark = path.getQuark(baseQuark, container);
        if (quark >= 0) {
            ITmfStateSystem stateSystem = container.getStateSystem();
            ITmfStateInterval firstInterval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)container.getStateSystem(), (int)quark, (long)stateSystem.getStartTime(), (long)stateSystem.getCurrentEndTime());
            if (firstInterval != null) {
                return String.valueOf(firstInterval.getValue());
            }
        }
        return "";
    }

    private static class DataContainer
    implements IAnalysisDataContainer {
        private final ITmfStateSystem fStateSystem;

        public DataContainer(ITmfStateSystem ss) {
            this.fStateSystem = ss;
        }

        @Override
        public ITmfStateSystem getStateSystem() {
            return this.fStateSystem;
        }

        @Override
        public DataDrivenMappingGroup getMappingGroup(String id) {
            throw new UnsupportedOperationException("Mapping groups are not supported with views");
        }
    }

    @FunctionalInterface
    public static interface IdGetter {
        public long getIdFor(ITmfStateSystem var1, int var2);
    }

    public static interface QuarkCallback {
        public void registerQuark(long var1, ITmfStateSystem var3, int var4, DataDrivenXYDataProvider.DisplayType var5);
    }
}

