/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.WorkbenchMessages;

class DecorationReference {
    static final IDecorationContext[] EMPTY_DECORATION_CONTEXTS = new IDecorationContext[0];
    final Object element;
    final Object adaptedElement;
    String undecoratedText;
    boolean forceUpdate = false;
    final Set<IDecorationContext> contexts = new HashSet<IDecorationContext>();

    DecorationReference(Object object, Object adaptedObject, IDecorationContext context) {
        Assert.isNotNull((Object)object);
        this.element = object;
        this.adaptedElement = adaptedObject;
        this.addContext(context);
    }

    Object getAdaptedElement() {
        return this.adaptedElement;
    }

    Object getElement() {
        return this.element;
    }

    boolean shouldForceUpdate() {
        return this.forceUpdate;
    }

    void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    void setUndecoratedText(String text) {
        this.undecoratedText = text;
    }

    String getSubTask() {
        if (this.undecoratedText == null) {
            return WorkbenchMessages.DecorationReference_EmptyReference;
        }
        return NLS.bind((String)WorkbenchMessages.DecorationScheduler_DecoratingSubtask, (Object)this.undecoratedText);
    }

    Collection<IDecorationContext> getContexts() {
        return this.contexts;
    }

    void addContext(IDecorationContext context) {
        this.contexts.add(context);
    }
}

