/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.perf.trace;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapSeekBenchmark {
    private static final Random RND = new Random(1000L);
    private static final int LOOP_COUNT = 25;
    private static final int NB_SEEKS = 1000000;
    private static final String TEST_SUITE_NAME = "Pcap Read & Seek Benchmark (1000000 seeks)";
    private static final String TEST_ID = "org.eclipse.linuxtools#Pcap Read & Seek Benchmark (1000000 seeks)";

    @Test
    public void testPcapTrace() {
        PcapSeekBenchmark.readAndSeekTrace(PcapTestTrace.BENCHMARK_TRACE, "trace-pcap", true);
    }

    private static void readAndSeekTrace(PcapTestTrace testTrace, String testName, boolean inGlobalSummary) {
        Assume.assumeTrue((boolean)testTrace.exists());
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter("org.eclipse.linuxtools#Pcap Read & Seek Benchmark (1000000 seeks)#" + testName);
        perf.tagAsSummary(pm, "Pcap Read & Seek Benchmark (1000000 seeks):" + testName, Dimension.CPU_TIME);
        if (inGlobalSummary) {
            perf.tagAsGlobalSummary(pm, "Pcap Read & Seek Benchmark (1000000 seeks):" + testName, Dimension.CPU_TIME);
        }
        int loop = 0;
        while (loop < 25) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (PcapFile trace = testTrace.getTrace();){
                    trace.seekPacket(0L);
                    long nbPackets = trace.getTotalNbPackets();
                    LinkedList<Long> seekTimestamps = new LinkedList<Long>();
                    long range = nbPackets;
                    int i = 0;
                    while (i < 1000000) {
                        long rank = RND.nextLong() % range;
                        if (rank < 0L) {
                            rank += range;
                        }
                        seekTimestamps.add(rank);
                        ++i;
                    }
                    pm.start();
                    for (Long rank : seekTimestamps) {
                        trace.seekPacket(rank.longValue());
                        trace.parseNextPacket();
                    }
                    pm.stop();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | BadPacketException | BadPcapFileException e) {
                Assert.fail((String)("Test failed at iteration " + loop + ':' + e.getMessage()));
            }
            ++loop;
        }
        pm.commit();
    }
}

