/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.search.ui.ISearchResultViewEntry;

@Deprecated
public class SearchResultViewEntry
extends PlatformObject
implements ISearchResultViewEntry {
    private Object fGroupByKey = null;
    private IResource fResource = null;
    private IMarker fMarker = null;
    private ArrayList<IMarker> fMarkers = null;
    private ArrayList<Map<String, Object>> fAttributes;
    private int fSelectedMarkerIndex;
    private long fModificationStamp = -1L;
    private String fMarkerType;

    public SearchResultViewEntry(Object groupByKey, IResource resource) {
        this.fGroupByKey = groupByKey;
        this.fResource = resource;
        if (this.fResource != null) {
            this.fModificationStamp = this.fResource.getModificationStamp();
        }
    }

    @Override
    public Object getGroupByKey() {
        return this.fGroupByKey;
    }

    void setGroupByKey(Object groupByKey) {
        this.fGroupByKey = groupByKey;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public int getMatchCount() {
        if (this.fMarkers != null) {
            return this.fMarkers.size();
        }
        if (this.fMarkers == null && this.fMarker != null) {
            return 1;
        }
        return 0;
    }

    boolean isPotentialMatch() {
        if (this.fMarker != null) {
            return this.fMarker.getAttribute("potentialMatch", false);
        }
        return false;
    }

    List<Map<String, Object>> getAttributesPerMarker() {
        if (this.fAttributes == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        return this.fAttributes;
    }

    public long getModificationStamp() {
        return this.fModificationStamp;
    }

    void clearMarkerList() {
        this.fMarker = null;
        if (this.fMarkers != null) {
            this.fMarkers.clear();
        }
    }

    void add(IMarker marker) {
        if (marker != null && this.fMarkerType == null) {
            try {
                this.fMarkerType = marker.getType();
            }
            catch (CoreException coreException) {}
        }
        if (this.fMarker == null) {
            this.fMarker = marker;
            if (this.fMarkers != null) {
                this.fMarkers.add(marker);
            }
            return;
        }
        if (this.fMarkers == null) {
            this.fMarkers = new ArrayList(10);
            this.addByStartpos(this.fMarkers, this.fMarker);
        }
        this.addByStartpos(this.fMarkers, marker);
    }

    void setSelectedMarkerIndex(int index) {
        this.fSelectedMarkerIndex = index;
    }

    @Override
    public IMarker getSelectedMarker() {
        this.fSelectedMarkerIndex = Math.min(this.fSelectedMarkerIndex, this.getMatchCount() - 1);
        if (this.fMarkers == null && this.fMarker == null) {
            return null;
        }
        if (this.fMarkers != null && this.fSelectedMarkerIndex >= 0) {
            return this.fMarkers.get(this.fSelectedMarkerIndex);
        }
        return this.fMarker;
    }

    public List<IMarker> getMarkers() {
        if (this.fMarkers == null && this.fMarker == null) {
            return new ArrayList<IMarker>(0);
        }
        if (this.fMarkers == null && this.fMarker != null) {
            ArrayList<IMarker> markers = new ArrayList<IMarker>(1);
            markers.add(this.fMarker);
            return markers;
        }
        return this.fMarkers;
    }

    String getMarkerType() {
        if (this.fMarkerType == null) {
            return "org.eclipse.search.searchmarker";
        }
        return this.fMarkerType;
    }

    boolean contains(IMarker marker) {
        if (this.fMarkers == null && this.fMarker == null) {
            return false;
        }
        if (this.fMarkers == null) {
            return this.fMarker.equals((Object)marker);
        }
        return this.fMarkers.contains(marker);
    }

    void remove(IMarker marker) {
        if (marker == null) {
            return;
        }
        if (this.fMarkers == null) {
            if (this.fMarker != null && this.fMarker.equals((Object)marker)) {
                this.fMarker = null;
            }
        } else {
            this.fMarkers.remove(marker);
            if (this.fMarkers.size() == 1) {
                this.fMarker = this.fMarkers.get(0);
                this.fMarkers = null;
            }
        }
    }

    void backupMarkers() {
        if (this.fResource != null) {
            this.fModificationStamp = this.fResource.getModificationStamp();
        }
        List<IMarker> markers = this.getMarkers();
        this.fAttributes = new ArrayList(markers.size());
        for (IMarker marker : markers) {
            Map attributes = null;
            try {
                attributes = marker.getAttributes();
            }
            catch (CoreException coreException) {
                continue;
            }
            this.fAttributes.add(attributes);
        }
    }

    private void addByStartpos(ArrayList<IMarker> markers, IMarker marker) {
        int startPos = marker.getAttribute("charStart", -1);
        int i = 0;
        int markerCount = markers.size();
        while (i < markerCount && startPos >= markers.get(i).getAttribute("charStart", -1)) {
            ++i;
        }
        markers.add(i, marker);
        if (i == 0) {
            this.fMarker = marker;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)super.getAdapter(adapter);
    }
}

