/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.contextswitch;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.contextswitch.KernelContextSwitchStateProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class KernelContextSwitchAnalysis
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.contextswitch";
    public static final Integer TOTAL = -1;

    public @NonNull String getHelpText() {
        String msg = Messages.KernelContextSwitchAnalysis_Description;
        return msg != null ? msg : super.getHelpText();
    }

    public @NonNull String getHelpText(@NonNull ITmfTrace trace) {
        return this.getHelpText();
    }

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        IKernelAnalysisEventLayout layout = trace instanceof IKernelTrace ? ((IKernelTrace)trace).getKernelEventLayout() : DefaultEventLayout.getInstance();
        return new KernelContextSwitchStateProvider(trace, layout);
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        HashSet<IAnalysisModule> modules = new HashSet<IAnalysisModule>();
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException("Analysis requires a trace");
        }
        Iterable kernelModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class);
        Iterator iterator = kernelModules.iterator();
        if (iterator.hasNext()) {
            KernelAnalysisModule kernelModule = (KernelAnalysisModule)((Object)iterator.next());
            modules.add((IAnalysisModule)kernelModule);
        }
        return modules;
    }

    @NonNullByDefault(value={})
    public @NonNull Map<Integer, Long> getContextSwitchesRange(long startParam, long endParam) {
        @Nullable ITmfStateSystem stateSystem = this.getStateSystem();
        ITmfTrace trace = this.getTrace();
        if (trace == null || stateSystem == null) {
            return Collections.emptyMap();
        }
        long start = Math.max(startParam, stateSystem.getStartTime());
        long end = Math.min(endParam, stateSystem.getCurrentEndTime());
        ITmfStateSystem contextSwitchStateSystem = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)ID);
        if (contextSwitchStateSystem == null) {
            return Collections.emptyMap();
        }
        long startTime = contextSwitchStateSystem.getStartTime();
        long endTime = contextSwitchStateSystem.getCurrentEndTime();
        if (endTime < startTime) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        try {
            int cpusNode = contextSwitchStateSystem.getQuarkAbsolute(new String[]{"CPUs"});
            List cpuQuarks = contextSwitchStateSystem.getSubAttributes(cpusNode, false);
            List kernelEndState = contextSwitchStateSystem.queryFullState(end);
            List kernelStartState = contextSwitchStateSystem.queryFullState(start);
            Long totalNbCxtSwt = 0L;
            for (Integer cpuQuark : cpuQuarks) {
                int cpuNb = Integer.parseInt(contextSwitchStateSystem.getAttributeName(cpuQuark.intValue()));
                Long nbCxtSwtForCore = ((ITmfStateInterval)kernelEndState.get(cpuQuark)).getStateValue().unboxLong() - ((ITmfStateInterval)kernelStartState.get(cpuQuark)).getStateValue().unboxLong();
                map.put(cpuNb, nbCxtSwtForCore);
                totalNbCxtSwt = totalNbCxtSwt + nbCxtSwtForCore;
            }
            map.put(TOTAL, totalNbCxtSwt);
        }
        catch (AttributeNotFoundException | TimeRangeException throwable) {
        }
        catch (StateSystemDisposedException | StateValueTypeException e) {
            Activator.getDefault().logError("Error getting CPU context switches in a time range", e);
        }
        return map;
    }
}

