/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.operations;

import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class LinearUndoViolationDetector
implements IOperationApprover {
    protected abstract IStatus allowLinearRedoViolation(IUndoableOperation var1, IUndoContext var2, IOperationHistory var3, IAdaptable var4);

    protected abstract IStatus allowLinearUndoViolation(IUndoableOperation var1, IUndoContext var2, IOperationHistory var3, IAdaptable var4);

    @Override
    public final IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        IUndoContext[] contexts;
        IUndoContext[] iUndoContextArray = contexts = operation.getContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            IUndoContext context = iUndoContextArray[n2];
            if (history.getRedoOperation(context) != operation && !(status = this.allowLinearRedoViolation(operation, context, history, info)).isOK()) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    @Override
    public final IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        IUndoContext[] contexts;
        IUndoContext[] iUndoContextArray = contexts = operation.getContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            IUndoContext context = iUndoContextArray[n2];
            if (history.getUndoOperation(context) != operation && !(status = this.allowLinearUndoViolation(operation, context, history, info)).isOK()) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }
}

