/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class SurrogateProfileHandler
implements ISurrogateProfileHandler {
    private static final String NATIVE_TOUCHPOINT_TYPE = "org.eclipse.equinox.p2.native";
    private static final String P2_ENGINE_DIR = "p2/org.eclipse.equinox.p2.engine/";
    private static final String OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String ECLIPSE_INI_IGNORED = "eclipse.ini.ignored";
    private static final String IU_LOCKED = Integer.toString(3);
    private static final String PROP_SURROGATE = "org.eclipse.equinox.p2.surrogate";
    private static final String PROP_BASE = "org.eclipse.equinox.p2.base";
    private static final String STRICT = "STRICT";
    private static final String PROP_INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    private final IProvisioningAgent agent;
    private SimpleProfileRegistry profileRegistry;
    private SoftReference<IProfile> cachedProfile;

    private static void addSharedProfileBaseIUs(IProfile sharedProfile, Profile userProfile) {
        IQuery rootIUQuery = QueryUtil.createMatchQuery((String)"profileProperties[$0] == 'true' || (touchpointType != null && touchpointType.id == $1)", (Object[])new Object[]{"org.eclipse.equinox.p2.type.root", NATIVE_TOUCHPOINT_TYPE});
        IQueryResult rootIUs = sharedProfile.query(rootIUQuery, null);
        for (IInstallableUnit iu : rootIUs) {
            userProfile.addInstallableUnit(iu);
            userProfile.addInstallableUnitProperties(iu, sharedProfile.getInstallableUnitProperties(iu));
            userProfile.setInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock", IU_LOCKED);
            userProfile.setInstallableUnitProperty(iu, PROP_BASE, Boolean.TRUE.toString());
        }
        IInstallableUnit sharedProfileIU = SurrogateProfileHandler.createSharedProfileIU(sharedProfile);
        userProfile.addInstallableUnit(sharedProfileIU);
        userProfile.setInstallableUnitProperty(sharedProfileIU, PROP_INCLUSION_RULES, STRICT);
        userProfile.setInstallableUnitProperty(sharedProfileIU, PROP_BASE, Boolean.TRUE.toString());
    }

    private static IInstallableUnit createSharedProfileIU(IProfile sharedProfile) {
        MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
        iuDescription.setId("SharedProfile_" + sharedProfile.getProfileId());
        iuDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0, (String)Long.toString(sharedProfile.getTimestamp())));
        ArrayList<IProvidedCapability> iuCapabilities = new ArrayList<IProvidedCapability>();
        IProvidedCapability selfCapability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)iuDescription.getId(), (Version)iuDescription.getVersion());
        iuCapabilities.add(selfCapability);
        iuDescription.addProvidedCapabilities(iuCapabilities);
        ArrayList<IRequirement> iuRequirements = new ArrayList<IRequirement>();
        IQueryResult allIUs = sharedProfile.query(QueryUtil.createIUAnyQuery(), null);
        for (IInstallableUnit iu : allIUs) {
            IMatchExpression iuMatcher = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)"id == $0 && version == $1"), new Object[]{iu.getId(), iu.getVersion()});
            iuRequirements.add(MetadataFactory.createRequirement((IMatchExpression)iuMatcher, null, (int)0, (int)1, (boolean)true));
        }
        iuDescription.addRequirements(iuRequirements);
        iuDescription.setProperty("org.eclipse.equinox.p2.name", NLS.bind((String)Messages.Shared_Profile, null));
        IInstallableUnit sharedProfileIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription);
        return sharedProfileIU;
    }

    private static void updateProperties(IProfile sharedProfile, Profile userProfile) {
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), Location.class, (String)Location.INSTALL_FILTER);
        File installFolder = URLUtil.toFile((URL)installLocation.getURL());
        if (installFolder == null) {
            installFolder = new File(installLocation.getURL().getPath());
        }
        if (Boolean.parseBoolean(sharedProfile.getProperty("org.eclipse.equinox.p2.roaming"))) {
            userProfile.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.getAbsolutePath());
            userProfile.setProperty("org.eclipse.equinox.p2.cache.shared", installFolder.getAbsolutePath());
            userProfile.setProperty("org.eclipse.equinox.p2.roaming", Boolean.FALSE.toString());
        } else {
            String cache = sharedProfile.getProperty("org.eclipse.equinox.p2.cache");
            if (cache != null) {
                userProfile.setProperty("org.eclipse.equinox.p2.cache.shared", cache);
            }
        }
        Location configurationLocation = (Location)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), Location.class, (String)Location.CONFIGURATION_FILTER);
        File configurationFolder = URLUtil.toFile((URL)configurationLocation.getURL());
        if (configurationFolder == null) {
            configurationFolder = new File(configurationLocation.getURL().getPath());
        }
        userProfile.setProperty("org.eclipse.equinox.p2.configurationFolder", configurationFolder.getAbsolutePath());
        if (configurationFolder.getParentFile() == null) {
            throw new IllegalArgumentException("Configuration folder must not be a file system root.");
        }
        userProfile.setProperty("org.eclipse.equinox.p2.cache", configurationFolder.getParentFile().getAbsolutePath());
        File launcherConfigFile = new File(configurationFolder, ECLIPSE_INI_IGNORED);
        userProfile.setProperty("org.eclipse.equinox.p2.launcherConfiguration", launcherConfigFile.getAbsolutePath());
    }

    public SurrogateProfileHandler(IProvisioningAgent agent) {
        this.agent = agent;
    }

    private synchronized SimpleProfileRegistry getProfileRegistry() {
        if (this.profileRegistry == null) {
            String installArea = EngineActivator.getContext().getProperty(OSGI_INSTALL_AREA);
            try {
                URL registryURL = new URL(String.valueOf(installArea) + P2_ENGINE_DIR + "profileRegistry");
                File sharedRegistryDirectory = URIUtil.toFile((URI)URIUtil.toURI((URL)registryURL));
                this.profileRegistry = new SimpleProfileRegistry(this.agent, sharedRegistryDirectory, null, false);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return this.profileRegistry;
    }

    private IProfile getSharedProfile(String id) {
        IProfile profile;
        SimpleProfileRegistry registry = this.getProfileRegistry();
        long[] timestamps = registry.listProfileTimestamps(id);
        if (timestamps.length == 0) {
            return null;
        }
        long currentTimestamp = timestamps[timestamps.length - 1];
        if (this.cachedProfile != null && (profile = this.cachedProfile.get()) != null && profile.getProfileId().equals(id) && profile.getTimestamp() == currentTimestamp) {
            return profile;
        }
        profile = (Profile)registry.getProfile(id, currentTimestamp);
        if (profile != null) {
            this.cachedProfile = new SoftReference<IProfile>(profile);
        }
        if (!EngineActivator.EXTENDED) {
            return profile;
        }
        this.setUpRepos();
        return profile;
    }

    private void setUpRepos() {
        File[] fragments;
        URI[] knownRepositories;
        IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        URI[] uRIArray = knownRepositories = metaManager.getKnownRepositories(4);
        int n = knownRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if ("true".equals(metaManager.getRepositoryProperty(uri, "p2.fragment"))) {
                metaManager.removeRepository(uri);
            }
            ++n2;
        }
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
        URI[] uRIArray2 = knownRepositories = artifactManager.getKnownRepositories(4);
        int n3 = knownRepositories.length;
        n = 0;
        while (n < n3) {
            URI uri = uRIArray2[n];
            if ("true".equals(artifactManager.getRepositoryProperty(uri, "p2.fragment"))) {
                artifactManager.removeRepository(uri);
            }
            ++n;
        }
        File[] fileArray = fragments = EngineActivator.getExtensionsDirectories();
        int n4 = fragments.length;
        n3 = 0;
        while (n3 < n4) {
            File f = fileArray[n3];
            metaManager.addRepository(f.toURI());
            metaManager.setRepositoryProperty(f.toURI(), "p2.fragment", Boolean.TRUE.toString());
            artifactManager.addRepository(f.toURI());
            artifactManager.setRepositoryProperty(f.toURI(), "p2.fragment", Boolean.TRUE.toString());
            ++n3;
        }
    }

    @Override
    public IProfile createProfile(String id) {
        Profile sharedProfile = (Profile)this.getSharedProfile(id);
        if (sharedProfile == null) {
            return null;
        }
        if (!EngineActivator.EXTENDED) {
            Profile userProfile = new Profile(this.agent, id, null, sharedProfile.getProperties());
            userProfile.setProperty(PROP_SURROGATE, Boolean.TRUE.toString());
            userProfile.setSurrogateProfileHandler(this);
            SurrogateProfileHandler.updateProperties(sharedProfile, userProfile);
            SurrogateProfileHandler.addSharedProfileBaseIUs(sharedProfile, userProfile);
            return userProfile;
        }
        File[] extensionLocations = EngineActivator.getExtensionsDirectories();
        HashSet<IInstallableUnit> added = new HashSet<IInstallableUnit>();
        File[] fileArray = extensionLocations;
        int n = extensionLocations.length;
        int n2 = 0;
        while (n2 < n) {
            File extension = fileArray[n2];
            try {
                IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
                IMetadataRepository repo = metaManager.loadRepository(extension.toURI(), (IProgressMonitor)new NullProgressMonitor());
                Set installableUnits = repo.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
                for (IInstallableUnit unit : installableUnits) {
                    Map iuProperties;
                    Collection capabilities = unit.getProvidedCapabilities();
                    boolean featureOrBundle = false;
                    for (IProvidedCapability cap : capabilities) {
                        if (!"org.eclipse.equinox.p2.eclipse.type".equals(cap.getNamespace()) || !"bundle".equals(cap.getName()) && !"source".equals(cap.getName()) && !"feature".equals(cap.getName())) continue;
                        featureOrBundle = true;
                    }
                    if (Boolean.TRUE.equals(Boolean.valueOf((String)unit.getProperties().get("org.eclipse.equinox.p2.type.group")))) {
                        featureOrBundle = true;
                    }
                    if (featureOrBundle && !added.contains(unit)) {
                        added.add(unit);
                        sharedProfile.addInstallableUnit(unit);
                    }
                    if ((iuProperties = unit.getProperties()) == null || iuProperties.isEmpty()) continue;
                    sharedProfile.addInstallableUnitProperties(unit, iuProperties);
                }
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.SurrogateProfileHandler_1, (Object)extension), (Throwable)e));
            }
            ++n2;
        }
        Profile userProfile = new Profile(this.agent, id, null, sharedProfile.getProperties());
        userProfile.setProperty(PROP_SURROGATE, Boolean.TRUE.toString());
        userProfile.setSurrogateProfileHandler(this);
        SurrogateProfileHandler.updateProperties(sharedProfile, userProfile);
        SurrogateProfileHandler.addSharedProfileBaseIUs(sharedProfile, userProfile);
        return userProfile;
    }

    @Override
    public boolean isSurrogate(IProfile profile) {
        return Boolean.parseBoolean(profile.getProperty(PROP_SURROGATE));
    }

    @Override
    public IQueryResult<IInstallableUnit> queryProfile(IProfile profile, IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        IProfile sharedProfile = this.getSharedProfile(profile.getProfileId());
        if (sharedProfile == null) {
            return profile.query(query, monitor);
        }
        Collector result = new Collector();
        result.addAll(sharedProfile.query(query, monitor));
        result.addAll(profile.query(query, monitor));
        return result;
    }
}

