/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser.regions;

import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionToStringUtil;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionUpdateRule;

public class WhiteSpaceOnlyRegion
implements ITextRegion {
    private static final byte fTextLength = 0;
    private static final String fType = "WHITE_SPACE";
    protected int fLength;
    protected int fStart;

    public WhiteSpaceOnlyRegion(int start, int length) {
        this.fStart = start;
        this.fLength = length;
    }

    public void adjust(int i) {
        this.fStart += i;
    }

    public void adjustLength(int i) {
        this.fLength += i;
    }

    public void adjustStart(int i) {
        this.fStart += i;
    }

    public void adjustTextLength(int i) {
    }

    public boolean contains(int position) {
        return this.fStart <= position && position < this.fStart + this.fLength;
    }

    public void equatePositions(ITextRegion region) {
        this.fStart = region.getStart();
        this.fLength = region.getLength();
    }

    public int getEnd() {
        return this.fStart + this.fLength;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getTextEnd() {
        return this.fStart + 0;
    }

    public int getTextLength() {
        return 0;
    }

    public String getType() {
        return fType;
    }

    public void setLength(int i) {
        this.fLength = i;
    }

    public void setStart(int i) {
        this.fStart = i;
    }

    public void setTextLength(short i) {
        throw new RuntimeException("invalid call");
    }

    public void setType(String string) {
        throw new RuntimeException("invalid call");
    }

    public String toString() {
        return RegionToStringUtil.toString(this);
    }

    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        boolean canHandle = false;
        canHandle = changes == null || changes.length() == 0 ? this.fStart < this.getTextEnd() && Math.abs(lengthToReplace) < this.getTextEnd() - this.getStart() : RegionUpdateRule.canHandleAsWhiteSpace(this, parent, changes, requestStart, lengthToReplace);
        RegionChangedEvent result = null;
        if (canHandle) {
            int lengthDifference = Utilities.calculateLengthDifference((String)changes, (int)lengthToReplace);
            this.fLength += lengthDifference;
            result = new RegionChangedEvent(parent.getParentDocument(), requester, parent, (ITextRegion)this, changes, requestStart, lengthToReplace);
        }
        return result;
    }
}

