/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.search2.internal.ui.MatchFilterSelectionDialog;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.swt.widgets.Shell;

public class MatchFilterSelectionAction
extends Action {
    public static final String ACTION_ID = "MatchFilterSelectionAction";
    private AbstractTextSearchViewPage fPage;

    public MatchFilterSelectionAction(AbstractTextSearchViewPage page) {
        super(SearchMessages.MatchFilterSelectionAction_label);
        this.setId(ACTION_ID);
        SearchPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.search.ui.filter_ps.png");
        this.fPage = page;
    }

    public void run() {
        int elementLimit;
        Integer limit;
        boolean enableLimitConfiguration;
        Shell shell = this.fPage.getSite().getShell();
        AbstractTextSearchResult input = this.fPage.getInput();
        if (input == null) {
            return;
        }
        MatchFilter[] allFilters = input.getAllMatchFilters();
        MatchFilter[] checkedFilters = input.getActiveMatchFilters();
        boolean enableMatchFilterConfiguration = checkedFilters != null;
        MatchFilterSelectionDialog dialog = new MatchFilterSelectionDialog(shell, enableMatchFilterConfiguration, allFilters, checkedFilters, enableLimitConfiguration = (limit = this.fPage.getElementLimit()) != null, elementLimit = limit != null ? limit : -1);
        if (dialog.open() == 0) {
            if (enableMatchFilterConfiguration) {
                input.setActiveMatchFilters(dialog.getMatchFilters());
            }
            if (enableLimitConfiguration) {
                this.fPage.setElementLimit(dialog.getLimit());
            }
        }
    }
}

