/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.relayd;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.ILttngRelaydConnector;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.AttachReturnCode;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.AttachSessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.CreateSessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.CreateSessionReturnCode;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IndexResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.NextIndexReturnCode;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.SessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.StreamResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.impl.LttngRelaydConnectorFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConnectionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public final class LttngRelaydConsumer {
    private static final Pattern PROTOCOL_HOST_PATTERN = Pattern.compile("(\\S+://)*(\\d+\\.\\d+\\.\\d+\\.\\d+)");
    private static final int SIGNAL_THROTTLE_NANOSEC = 10000000;
    private static final String ENCODING_UTF_8 = "UTF-8";
    private Job fConsumerJob;
    private CtfTmfTrace fCtfTmfTrace;
    private long fTimestampEnd;
    private AttachSessionResponse fSession;
    private Socket fConnection;
    private ILttngRelaydConnector fRelayd;
    private String fTracePath;
    private long fLastSignal = 0L;
    private final LttngRelaydConnectionInfo fConnectionInfo;

    LttngRelaydConsumer(LttngRelaydConnectionInfo connectionInfo) {
        this.fConnectionInfo = connectionInfo;
        this.fTimestampEnd = 0L;
    }

    public void connect() throws CoreException {
        if (this.fConnection != null) {
            return;
        }
        try {
            Matcher matcher = PROTOCOL_HOST_PATTERN.matcher(this.fConnectionInfo.getHost());
            String host = null;
            if (matcher.matches()) {
                host = matcher.group(2);
            }
            if (host == null || host.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.LttngRelaydConsumer_ErrorConnecting));
            }
            this.fConnection = new Socket(host, this.fConnectionInfo.getPort());
            this.fRelayd = LttngRelaydConnectorFactory.getNewConnector((Socket)this.fConnection);
            List sessions = this.fRelayd.getSessions();
            SessionResponse selectedSession = null;
            for (SessionResponse session : sessions) {
                String asessionName = LttngRelaydConsumer.nullTerminatedByteArrayToString(session.getSessionName().getBytes());
                if (!asessionName.equals(this.fConnectionInfo.getSessionName())) continue;
                selectedSession = session;
                break;
            }
            if (selectedSession == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.LttngRelaydConsumer_SessionNotFound));
            }
            CreateSessionResponse createSession = this.fRelayd.createSession();
            if (createSession.getStatus() != CreateSessionReturnCode.LTTNG_VIEWER_CREATE_SESSION_OK) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", String.valueOf(Messages.LttngRelaydConsumer_CreateViewerSessionError) + createSession.getStatus().toString()));
            }
            AttachSessionResponse attachedSession = this.fRelayd.attachToSession(selectedSession);
            if (attachedSession.getStatus() != AttachReturnCode.VIEWER_ATTACH_OK) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", String.valueOf(Messages.LttngRelaydConsumer_AttachSessionError) + attachedSession.getStatus().toString()));
            }
            String metadata = this.fRelayd.getMetadata(attachedSession);
            if (metadata == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.LttngRelaydConsumer_NoMetadata));
            }
            List attachedStreams = attachedSession.getStreamList();
            if (attachedStreams.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.LttngRelaydConsumer_NoStreams));
            }
            this.fTracePath = LttngRelaydConsumer.nullTerminatedByteArrayToString(((StreamResponse)attachedStreams.get(0)).getPathName().getBytes());
            this.fSession = attachedSession;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", String.valueOf(Messages.LttngRelaydConsumer_ErrorConnecting) + (e.getMessage() != null ? e.getMessage() : "")));
        }
    }

    public void run(CtfTmfTrace trace) {
        if (this.fSession == null) {
            return;
        }
        this.fCtfTmfTrace = trace;
        this.fConsumerJob = new Job("RelayD consumer"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    while (!monitor.isCanceled()) {
                        List attachedStreams = LttngRelaydConsumer.this.fSession.getStreamList();
                        for (StreamResponse stream : attachedStreams) {
                            if (stream.getMetadataFlag() == 1) continue;
                            IndexResponse indexReply = LttngRelaydConsumer.this.fRelayd.getNextIndex(stream);
                            if (indexReply.getStatus() == NextIndexReturnCode.VIEWER_INDEX_OK) {
                                long nanoTimeStamp = LttngRelaydConsumer.this.fCtfTmfTrace.timestampCyclesToNanos(indexReply.getTimestampEnd());
                                if (nanoTimeStamp <= LttngRelaydConsumer.this.fTimestampEnd) continue;
                                ITmfTimestamp endTime = TmfTimestamp.fromNanos((long)nanoTimeStamp);
                                TmfTimeRange range = new TmfTimeRange(LttngRelaydConsumer.this.fCtfTmfTrace.getStartTime(), endTime);
                                long currentTime = System.nanoTime();
                                if (currentTime - LttngRelaydConsumer.this.fLastSignal > 10000000L) {
                                    TmfTraceRangeUpdatedSignal signal = new TmfTraceRangeUpdatedSignal((Object)LttngRelaydConsumer.this, (ITmfTrace)LttngRelaydConsumer.this.fCtfTmfTrace, range);
                                    LttngRelaydConsumer.this.fCtfTmfTrace.broadcastAsync((TmfSignal)signal);
                                    LttngRelaydConsumer.this.fLastSignal = currentTime;
                                }
                                LttngRelaydConsumer.this.fTimestampEnd = nanoTimeStamp;
                                continue;
                            }
                            if (indexReply.getStatus() != NextIndexReturnCode.VIEWER_INDEX_HUP) continue;
                            LttngRelaydConsumer.this.fCtfTmfTrace.setComplete(true);
                            TmfTraceRangeUpdatedSignal signal = new TmfTraceRangeUpdatedSignal((Object)LttngRelaydConsumer.this, (ITmfTrace)LttngRelaydConsumer.this.fCtfTmfTrace, new TmfTimeRange(LttngRelaydConsumer.this.fCtfTmfTrace.getStartTime(), TmfTimestamp.fromNanos((long)LttngRelaydConsumer.this.fTimestampEnd)));
                            LttngRelaydConsumer.this.fCtfTmfTrace.broadcastAsync((TmfSignal)signal);
                            return Status.OK_STATUS;
                        }
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().logError("Error during live trace reading", e);
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", String.valueOf(Messages.LttngRelaydConsumer_ErrorLiveReading) + (e.getMessage() != null ? e.getMessage() : ""));
                }
                return Status.OK_STATUS;
            }
        };
        this.fConsumerJob.setSystem(true);
        this.fConsumerJob.schedule();
    }

    public void dispose() {
        try {
            if (this.fConsumerJob != null) {
                this.fConsumerJob.cancel();
                this.fConsumerJob.join();
            }
            if (this.fConnection != null) {
                this.fConnection.close();
            }
            if (this.fRelayd != null) {
                this.fRelayd.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public String getTracePath() {
        return this.fTracePath;
    }

    private static String nullTerminatedByteArrayToString(byte[] byteArray) throws UnsupportedEncodingException {
        int length = 0;
        while (length < byteArray.length && byteArray[length] != 0) {
            ++length;
        }
        String asessionName = new String(byteArray, 0, length, ENCODING_UTF_8);
        return asessionName;
    }
}

