/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.presentation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.DefaultColorPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IXYPresentationProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class XYPresentationProvider
implements IXYPresentationProvider {
    private static final List<String> SUPPORTED_STYLES = ImmutableList.of((Object)"SOLID", (Object)"DASH", (Object)"DOT", (Object)"DASHDOT", (Object)"DASHDOTDOT");
    private static final List<String> SUPPORTED_TYPES = ImmutableList.of((Object)"area", (Object)"bar", (Object)"line", (Object)"scatter");
    private static final List<String> SUPPORTED_TICKS = ImmutableList.of((Object)"diamond", (Object)"circle", (Object)"square", (Object)"triangle", (Object)"inverted-triangle", (Object)"plus", (Object)"cross");
    private static final IPaletteProvider COLOR_PALETTE = DefaultColorPaletteProvider.INSTANCE;
    private final Map<Long, OutputElementStyle> fYAppearances = new HashMap<Long, OutputElementStyle>();

    @Override
    public @NonNull OutputElementStyle getSeriesStyle(Long seriesId, @NonNull String type, int width) {
        OutputElementStyle appearance = this.fYAppearances.get(seriesId);
        if (appearance != null) {
            return appearance;
        }
        if (!SUPPORTED_TYPES.contains(type)) {
            throw new UnsupportedOperationException("Series type: " + type + " is not supported.");
        }
        appearance = "scatter".equals(type) ? this.createScatter(seriesId, type, width) : this.createAppearance(seriesId, type, width);
        this.fYAppearances.put(seriesId, appearance);
        return appearance;
    }

    @Override
    public void clear() {
        this.fYAppearances.clear();
    }

    private OutputElementStyle createAppearance(Long seriesId, String seriesType, int width) {
        RGBAColor color = this.generateColor();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"style-name", (Object)seriesId);
        builder.put((Object)"series-type", (Object)seriesType);
        builder.put((Object)"series-style", (Object)this.generateStyle(seriesType));
        builder.put((Object)"color", (Object)X11ColorUtils.toHexColor(color.getRed(), color.getGreen(), color.getBlue()));
        builder.put((Object)"width", (Object)width);
        return new OutputElementStyle(null, (Map<String, Object>)builder.build());
    }

    private OutputElementStyle createScatter(Long seriesId, String seriesType, int width) {
        RGBAColor color = this.generateColor();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"style-name", (Object)seriesId);
        builder.put((Object)"series-type", (Object)seriesType);
        builder.put((Object)"series-style", (Object)"NONE");
        builder.put((Object)"color", (Object)X11ColorUtils.toHexColor(color.getRed(), color.getGreen(), color.getBlue()));
        builder.put((Object)"width", (Object)width);
        builder.put((Object)"symbol-type", (Object)this.generateTickStyle(seriesType));
        return new OutputElementStyle(null, (Map<String, Object>)builder.build());
    }

    private RGBAColor generateColor() {
        Object colors = COLOR_PALETTE.get();
        return (RGBAColor)Iterables.get((Iterable)colors, (int)(this.fYAppearances.keySet().size() % colors.size()));
    }

    private String generateStyle(String type) {
        if (!"scatter".equals(type)) {
            int nbColor = COLOR_PALETTE.get().size();
            return (String)Iterables.get(SUPPORTED_STYLES, (int)(this.fYAppearances.keySet().size() / nbColor % SUPPORTED_STYLES.size()));
        }
        return "NONE";
    }

    private String generateTickStyle(String type) {
        if ("scatter".equals(type)) {
            return (String)Iterables.get(SUPPORTED_TICKS, (int)(this.fYAppearances.keySet().size() / COLOR_PALETTE.get().size() % SUPPORTED_TICKS.size()));
        }
        return "NONE";
    }

    public void setStyle(long id, OutputElementStyle style) {
        this.fYAppearances.put(id, style);
    }
}

