/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.Requirement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;

public class RequiredCapability
extends Requirement
implements IRequiredCapability {
    private static final IExpression ALL = ExpressionUtil.parse(String.format("%s.exists(x | x.%s == $0 && x.%s == $1)", "providedCapabilities", "name", "namespace"));
    private static final IExpression STRICT = ExpressionUtil.parse(String.format("%s.exists(x | x.%s == $0 && x.%s == $1 && x.%s == $2)", "providedCapabilities", "name", "namespace", "version"));
    private static final IExpression OPEN_I = ExpressionUtil.parse(String.format("%s.exists(x | x.%s == $0 && x.%s == $1 && x.%s >= $2)", "providedCapabilities", "name", "namespace", "version"));
    private static final IExpression OPEN_N = ExpressionUtil.parse(String.format("%s.exists(x | x.%s == $0 && x.%s == $1 && x.%s > $2)", "providedCapabilities", "name", "namespace", "version"));
    private static final IExpression CLOSED_II = ExpressionUtil.parse(String.format("%s.exists(x | x.%s == $0 && x.%s == $1 && x.%s >= $2 && x.%s <= $3)", "providedCapabilities", "name", "namespace", "version", "version"));
    private static final IExpression CLOSED_IN = ExpressionUtil.parse(String.format("%s.exists(x | x.%s == $0 && x.%s == $1 && x.%s >= $2 && x.%s < $3)", "providedCapabilities", "name", "namespace", "version", "version"));
    private static final IExpression CLOSED_NI = ExpressionUtil.parse(String.format("%s.exists(x | x.%s == $0 && x.%s == $1 && x.%s > $2 && x.%s <= $3)", "providedCapabilities", "name", "namespace", "version", "version"));
    private static final IExpression CLOSED_NN = ExpressionUtil.parse(String.format("%s.exists(x | x.%s == $0 && x.%s == $1 && x.%s > $2 && x.%s < $3)", "providedCapabilities", "name", "namespace", "version", "version"));
    private static final List<IExpression> PREDEFINED = Arrays.asList(ALL, STRICT, OPEN_I, OPEN_N, CLOSED_II, CLOSED_IN, CLOSED_NI, CLOSED_NN);

    @Deprecated
    public RequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple) {
        this(namespace, name, range, filter, optional, multiple, true);
    }

    @Deprecated
    public RequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple, boolean greedy) {
        this(namespace, name, range, InstallableUnit.parseFilter(filter), optional ? 0 : 1, multiple ? Integer.MAX_VALUE : 1, greedy, null);
    }

    public RequiredCapability(String namespace, String name, VersionRange range, IMatchExpression<IInstallableUnit> filter, int min, int max, boolean greedy, String description) {
        super(RequiredCapability.createMatchExpressionFromRange(namespace, name, range), filter, min, max, greedy, description);
    }

    @Override
    public String getNamespace() {
        return RequiredCapability.extractNamespace(this.matchExpression);
    }

    @Override
    public String getName() {
        return RequiredCapability.extractName(this.matchExpression);
    }

    @Override
    public VersionRange getRange() {
        return RequiredCapability.extractRange(this.matchExpression);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getNamespace());
        result.append("; ");
        result.append(this.getName());
        result.append(" ");
        result.append(this.getRange());
        return result.toString();
    }

    public static IMatchExpression<IInstallableUnit> createMatchExpressionFromRange(String namespace, String name, VersionRange range) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)name);
        IExpressionFactory factory = ExpressionUtil.getFactory();
        if (range == null || range.equals(VersionRange.emptyRange)) {
            return factory.matchExpression(ALL, name, namespace);
        }
        if (range.getMinimum().equals(range.getMaximum())) {
            return factory.matchExpression(STRICT, name, namespace, range.getMinimum());
        }
        if (range.getMaximum().equals(Version.MAX_VERSION)) {
            IExpression expr = range.getIncludeMinimum() ? OPEN_I : OPEN_N;
            return factory.matchExpression(expr, name, namespace, range.getMinimum());
        }
        IExpression expr = range.getIncludeMinimum() ? (range.getIncludeMaximum() ? CLOSED_II : CLOSED_IN) : (range.getIncludeMaximum() ? CLOSED_NI : CLOSED_NN);
        return factory.matchExpression(expr, name, namespace, range.getMinimum(), range.getMaximum());
    }

    public static String extractName(IMatchExpression<IInstallableUnit> matchExpression) {
        RequiredCapability.assertVersionRangeRequirement(matchExpression);
        return (String)matchExpression.getParameters()[0];
    }

    public static String extractNamespace(IMatchExpression<IInstallableUnit> matchExpression) {
        RequiredCapability.assertVersionRangeRequirement(matchExpression);
        return (String)matchExpression.getParameters()[1];
    }

    public static VersionRange extractRange(IMatchExpression<IInstallableUnit> matchExpression) {
        RequiredCapability.assertVersionRangeRequirement(matchExpression);
        IExpression expr = ExpressionUtil.getOperand(matchExpression);
        Object[] params = matchExpression.getParameters();
        switch (params.length) {
            case 2: {
                return VersionRange.emptyRange;
            }
            case 3: {
                Version v = (Version)params[2];
                if (expr.equals(STRICT)) {
                    return new VersionRange(v, true, v, true);
                }
                return new VersionRange(v, expr.equals(OPEN_I), Version.MAX_VERSION, true);
            }
        }
        Version left = (Version)params[2];
        boolean leftInclusive = expr.equals(CLOSED_II) || expr.equals(CLOSED_IN);
        Version right = (Version)params[3];
        boolean rightInclusive = expr.equals(CLOSED_II) || expr.equals(CLOSED_NI);
        return new VersionRange(left, leftInclusive, right, rightInclusive);
    }

    public static boolean isStrictVersionRequirement(IMatchExpression<IInstallableUnit> matchExpression) {
        return STRICT == ExpressionUtil.getOperand(matchExpression);
    }

    public static boolean isVersionRangeRequirement(IMatchExpression<IInstallableUnit> matchExpression) {
        return PREDEFINED.contains(ExpressionUtil.getOperand(matchExpression));
    }

    private static void assertVersionRangeRequirement(IMatchExpression<IInstallableUnit> matchExpression) {
        if (!RequiredCapability.isVersionRangeRequirement(matchExpression)) {
            throw new IllegalArgumentException();
        }
    }
}

