/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ShowCommandLineDialog
extends Dialog {
    Text fModuleArgumentsText;
    ILaunchConfiguration flaunchConfiguration;
    String fMode;

    public ShowCommandLineDialog(Shell parentShell, String mode, ILaunchConfiguration config) {
        super(parentShell);
        this.fMode = mode;
        this.setShellStyle(0x10 | this.getShellStyle());
        this.flaunchConfiguration = config;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(LaunchConfigurationsMessages.LaunchConfigurationDialog_ShowCommandLine_Title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, LaunchConfigurationsMessages.LaunchConfigurationDialog_ShowCommandLine_Copy, true);
        this.createButton(parent, 1, LaunchConfigurationsMessages.LaunchConfigurationDialog_ShowCommandLine_Close, false);
    }

    private LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        Group group = new Group(comp, 0);
        GridLayout topLayout = new GridLayout();
        group.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        this.fModuleArgumentsText = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fModuleArgumentsText.setLayoutData((Object)gd);
        String command = "";
        try {
            Set modes = this.flaunchConfiguration.getModes();
            modes.add(this.fMode);
            ILaunchDelegate[] delegates = this.flaunchConfiguration.getType().getDelegates(modes);
            ILaunchConfigurationDelegate delegate = null;
            if (delegates.length == 1) {
                delegate = delegates[0].getDelegate();
            } else if (this.flaunchConfiguration instanceof LaunchConfiguration) {
                delegate = ((LaunchConfiguration)this.flaunchConfiguration).getPreferredLaunchDelegate(this.fMode);
            }
            if (delegate != null) {
                ILaunch launch = null;
                if (delegate instanceof ILaunchConfigurationDelegate2) {
                    ILaunchConfigurationDelegate2 delegate2 = (ILaunchConfigurationDelegate2)delegate;
                    if (delegate2 != null) {
                        launch = delegate2.getLaunch(this.flaunchConfiguration, this.fMode);
                    }
                    if (launch == null) {
                        launch = new Launch(this.flaunchConfiguration, this.fMode, null);
                    } else if (!this.fMode.equals(launch.getLaunchMode())) {
                        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, MessageFormat.format(DebugCoreMessages.LaunchConfiguration_14, this.fMode, launch.getLaunchMode()), null);
                        throw new CoreException((IStatus)status);
                    }
                    launch.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", this.getLaunchManager().getEncoding(this.flaunchConfiguration));
                }
                command = delegate.showCommandLine(this.flaunchConfiguration, this.fMode, launch, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (command == null || command != null && command.length() == 0) {
            command = LaunchConfigurationsMessages.LaunchConfigurationDialog_ShowCommandLine_Default;
        }
        this.fModuleArgumentsText.setText(command);
        this.fModuleArgumentsText.setEditable(false);
        return comp;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Clipboard clipboard = new Clipboard(null);
            try {
                TextTransfer textTransfer = TextTransfer.getInstance();
                Transfer[] transfers = new Transfer[]{textTransfer};
                Object[] data = new Object[]{this.fModuleArgumentsText.getText()};
                clipboard.setContents(data, transfers);
            }
            finally {
                clipboard.dispose();
            }
        }
        super.buttonPressed(buttonId);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected String getDialogSettingsSectionName() {
        return "SHOW_COMMAND_LINE_DIALOG";
    }
}

