/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class StreamDecoder {
    private static final int BUFFER_SIZE = 4096;
    private final CharsetDecoder decoder;
    private final ByteBuffer inputBuffer;
    private final CharBuffer outputBuffer;
    private boolean finished;

    public StreamDecoder(Charset charset) {
        this.decoder = charset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.inputBuffer = ByteBuffer.allocate(4096);
        this.inputBuffer.flip();
        this.outputBuffer = CharBuffer.allocate(4096);
        this.finished = false;
    }

    private void consume(StringBuilder consumer) {
        this.outputBuffer.flip();
        consumer.append(this.outputBuffer);
        this.outputBuffer.clear();
    }

    private void internalDecode(StringBuilder consumer, byte[] buffer, int offset, int length) {
        assert (offset >= 0);
        assert (length >= 0);
        int position = offset;
        int end = offset + length;
        assert (end <= buffer.length);
        boolean finishedReading = false;
        do {
            CoderResult result;
            if ((result = this.decoder.decode(this.inputBuffer, this.outputBuffer, false)).isOverflow()) {
                this.consume(consumer);
                continue;
            }
            if (result.isUnderflow()) {
                this.inputBuffer.compact();
                int remaining = this.inputBuffer.remaining();
                assert (remaining > 0);
                int read = Math.min(remaining, end - position);
                if (read > 0) {
                    this.inputBuffer.put(buffer, position, read);
                    position += read;
                } else {
                    finishedReading = true;
                }
                this.inputBuffer.flip();
                continue;
            }
            assert (false);
        } while (!finishedReading);
    }

    public void decode(StringBuilder consumer, byte[] buffer, int offset, int length) {
        this.internalDecode(consumer, buffer, offset, length);
        this.consume(consumer);
    }

    public void finish(StringBuilder consumer) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        CoderResult result = this.decoder.decode(this.inputBuffer, this.outputBuffer, true);
        assert (result.isOverflow() || result.isUnderflow());
        do {
            if ((result = this.decoder.flush(this.outputBuffer)).isOverflow()) {
                this.consume(consumer);
                continue;
            }
            assert (result.isUnderflow());
        } while (!result.isUnderflow());
        this.consume(consumer);
    }
}

