/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.databinding;

import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

class SelectionServiceListener<S extends ISelectionService, D extends IDiff>
extends NativePropertyListener<S, D>
implements ISelectionListener {
    private final String partId;
    private final boolean post;

    SelectionServiceListener(IProperty property, ISimplePropertyListener<S, D> wrapped, String partID, boolean post) {
        super(property, wrapped);
        this.partId = partID;
        this.post = post;
    }

    protected void doAddTo(S source) {
        S selectionService = source;
        if (this.post) {
            if (this.partId != null) {
                selectionService.addPostSelectionListener(this.partId, this);
            } else {
                selectionService.addPostSelectionListener(this);
            }
        } else if (this.partId != null) {
            selectionService.addSelectionListener(this.partId, this);
        } else {
            selectionService.addSelectionListener(this);
        }
    }

    protected void doRemoveFrom(S source) {
        S selectionService = source;
        if (this.post) {
            if (this.partId != null) {
                selectionService.removePostSelectionListener(this.partId, this);
            } else {
                selectionService.removePostSelectionListener(this);
            }
        } else if (this.partId != null) {
            selectionService.removeSelectionListener(this.partId, this);
        } else {
            selectionService.removeSelectionListener(this);
        }
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.fireChange((ISelectionService)((Object)part), null);
    }
}

