/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.relayd;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConnectionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConsumer;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.CtfConstants;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.ui.PlatformUI;

public final class LttngRelaydConnectionManager {
    private static LttngRelaydConnectionManager fConnectionManager;
    private Map<LttngRelaydConnectionInfo, LttngRelaydConsumer> fConnections = new HashMap<LttngRelaydConnectionInfo, LttngRelaydConsumer>();

    public static synchronized LttngRelaydConnectionManager getInstance() {
        if (fConnectionManager == null) {
            fConnectionManager = new LttngRelaydConnectionManager();
            TmfSignalManager.register((Object)fConnectionManager);
        }
        return fConnectionManager;
    }

    public LttngRelaydConsumer getConsumer(LttngRelaydConnectionInfo connectionInfo) {
        if (!this.fConnections.containsKey(connectionInfo)) {
            LttngRelaydConsumer lttngRelaydConsumer = new LttngRelaydConsumer(connectionInfo);
            this.fConnections.put(connectionInfo, lttngRelaydConsumer);
            return lttngRelaydConsumer;
        }
        return this.fConnections.get(connectionInfo);
    }

    private static LttngRelaydConnectionInfo getEntry(ITmfTrace trace) throws CoreException {
        CtfTmfTrace ctfTmfTrace;
        if (trace instanceof CtfTmfTrace && !(ctfTmfTrace = (CtfTmfTrace)trace).isComplete()) {
            IResource resource = ctfTmfTrace.getResource();
            String host = resource.getPersistentProperty(CtfConstants.LIVE_HOST);
            String port = resource.getPersistentProperty(CtfConstants.LIVE_PORT);
            String sessionName = resource.getPersistentProperty(CtfConstants.LIVE_SESSION_NAME);
            if (host != null && port != null && sessionName != null && !sessionName.isEmpty()) {
                LttngRelaydConnectionInfo entry = new LttngRelaydConnectionInfo(host, Integer.parseInt(port), sessionName);
                return entry;
            }
        }
        return null;
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        try {
            LttngRelaydConnectionInfo entry = LttngRelaydConnectionManager.getEntry(signal.getTrace());
            if (entry != null) {
                LttngRelaydConsumer consumer = this.getConsumer(entry);
                consumer.connect();
                consumer.run((CtfTmfTrace)signal.getTrace());
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(Messages.LttngRelaydConnectionManager_ConnectionError, e);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)Messages.LttngRelaydConnectionManager_ConnectionError, (IStatus)new Status(2, "org.eclipse.tracecompass.lttng2.control.ui", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        try {
            LttngRelaydConnectionInfo entry = LttngRelaydConnectionManager.getEntry(signal.getTrace());
            if (entry != null) {
                LttngRelaydConsumer comsumer = this.getConsumer(entry);
                if (comsumer != null) {
                    comsumer.dispose();
                }
                this.fConnections.remove(entry);
            }
        }
        catch (CoreException coreException) {}
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)this);
        for (LttngRelaydConsumer consumer : this.fConnections.values()) {
            consumer.dispose();
        }
    }
}

