/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis.requirements;

import java.util.Collection;
import java.util.Set;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;

public class TmfAnalysisEventRequirement
extends TmfAbstractAnalysisRequirement {
    public TmfAnalysisEventRequirement(Collection<String> eventNames) {
        super(eventNames, TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
    }

    public TmfAnalysisEventRequirement(Collection<String> eventNames, TmfAbstractAnalysisRequirement.PriorityLevel level) {
        super(eventNames, level);
    }

    @Override
    public boolean test(ITmfTrace trace) {
        if (!(trace instanceof ITmfTraceWithPreDefinedEvents)) {
            return true;
        }
        Set<String> traceEvents = TmfEventTypeCollectionHelper.getEventNames(((ITmfTraceWithPreDefinedEvents)((Object)trace)).getContainedEventTypes());
        Set<String> values = this.getValues();
        switch (this.getPriorityLevel()) {
            case ALL_OR_NOTHING: {
                traceEvents.retainAll(values);
                return traceEvents.isEmpty() || traceEvents.size() == values.size();
            }
            case AT_LEAST_ONE: {
                traceEvents.retainAll(values);
                return !traceEvents.isEmpty();
            }
            case MANDATORY: {
                return traceEvents.containsAll(values);
            }
            case OPTIONAL: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown value level: " + (Object)((Object)this.getPriorityLevel()));
    }
}

